/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;

public final class FieldMapping {
    private final String name;
    private final boolean index;
    private final float boost;
    private final boolean analyze;
    private final boolean store;
    private final boolean sortable;
    private final String analyzer;
    private final String indexNullAs;
    private final FieldDescriptor fieldDescriptor;
    private volatile boolean isInitialized = false;
    private Object indexNullAsObj;

    FieldMapping(String name, boolean index, float boost, boolean analyze, boolean store, boolean sortable, String analyzer, String indexNullAs, FieldDescriptor fieldDescriptor) {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if (fieldDescriptor == null) {
            throw new IllegalArgumentException("fieldDescriptor argument cannot be null");
        }
        this.name = name;
        this.index = index;
        this.boost = boost;
        this.analyze = analyze;
        this.store = store;
        this.sortable = sortable;
        this.analyzer = analyzer;
        this.indexNullAs = indexNullAs;
        this.fieldDescriptor = fieldDescriptor;
    }

    public String name() {
        return this.name;
    }

    public boolean index() {
        return this.index;
    }

    public float boost() {
        return this.boost;
    }

    public boolean analyze() {
        return this.analyze;
    }

    public boolean store() {
        return this.store;
    }

    public boolean sortable() {
        return this.sortable;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public Object indexNullAs() {
        this.init();
        return this.indexNullAsObj;
    }

    public String notParsedIndexNull() {
        return this.indexNullAs;
    }

    private void init() {
        if (!this.isInitialized) {
            if (this.fieldDescriptor.getType() == null) {
                throw new IllegalStateException("FieldDescriptors are not fully initialised!");
            }
            this.indexNullAsObj = this.parseIndexNullAs();
            this.isInitialized = true;
        }
    }

    public Object parseIndexNullAs() {
        if (this.indexNullAs != null) {
            switch (this.fieldDescriptor.getType()) {
                case DOUBLE: {
                    return Double.parseDouble(this.indexNullAs);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(this.indexNullAs));
                }
                case INT64: 
                case UINT64: 
                case FIXED64: 
                case SFIXED64: 
                case SINT64: {
                    return Long.parseLong(this.indexNullAs);
                }
                case INT32: 
                case FIXED32: 
                case UINT32: 
                case SFIXED32: 
                case SINT32: {
                    return Integer.parseInt(this.indexNullAs);
                }
                case ENUM: {
                    EnumValueDescriptor enumVal = this.fieldDescriptor.getEnumType().findValueByName(this.indexNullAs);
                    if (enumVal == null) {
                        throw new IllegalArgumentException("Enum value not found : " + this.indexNullAs);
                    }
                    return enumVal.getNumber();
                }
                case BOOL: {
                    return Boolean.valueOf(this.indexNullAs);
                }
            }
        }
        return this.indexNullAs;
    }

    public String toString() {
        return "FieldMapping{name='" + this.name + '\'' + ", index=" + this.index + ", boost=" + this.boost + ", analyze=" + this.analyze + ", store=" + this.store + ", sortable=" + this.sortable + ", analyzer='" + this.analyzer + '\'' + ", indexNullAs=" + this.indexNullAs + '}';
    }
}

