/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.mapping.reference;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.mapping.reference.FieldReferenceProvider;

public class MessageReferenceProvider {
    private final List<FieldReferenceProvider> fields;
    private final List<Embedded> embedded;

    public MessageReferenceProvider(Descriptor descriptor) {
        this.fields = new ArrayList<FieldReferenceProvider>(descriptor.getFields().size());
        this.embedded = new ArrayList<Embedded>();
        IndexingMetadata indexingMetadata = (IndexingMetadata)descriptor.getProcessedAnnotation("Indexed");
        if (indexingMetadata == null) {
            return;
        }
        for (FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            FieldReferenceProvider fieldReferenceProvider;
            String fieldName = fieldDescriptor.getName();
            if (Type.MESSAGE.equals((Object)fieldDescriptor.getType())) {
                if (!fieldDescriptor.getAnnotations().containsKey("Field") || !this.hasFieldAnnotation(fieldDescriptor.getMessageType())) continue;
                this.embedded.add(new Embedded(fieldName, fieldDescriptor.getMessageType().getFullName(), fieldDescriptor.isRepeated()));
                continue;
            }
            FieldMapping fieldMapping = indexingMetadata.getFieldMapping(fieldName);
            if (fieldMapping == null || (fieldReferenceProvider = new FieldReferenceProvider(fieldDescriptor, fieldMapping)).nothingToBind()) continue;
            this.fields.add(fieldReferenceProvider);
        }
    }

    private boolean hasFieldAnnotation(Descriptor descriptor) {
        return descriptor.getFields().stream().anyMatch(f -> f.getAnnotations().containsKey("Field"));
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public HashMap<String, IndexFieldReference<?>> bind(IndexSchemaElement indexSchemaElement, String basePath) {
        HashMap result = new HashMap();
        for (FieldReferenceProvider field : this.fields) {
            String newPath = "".equals(basePath) ? field.getName() : basePath + "." + field.getName();
            result.put(newPath, field.bind(indexSchemaElement));
        }
        return result;
    }

    public List<Embedded> getEmbedded() {
        return this.embedded;
    }

    public String toString() {
        return "{fields=" + this.fields + ", embedded=" + this.embedded + '}';
    }

    public static class Embedded {
        private final String fieldName;
        private final String typeFullName;
        private final boolean repeated;

        public Embedded(String fieldName, String typeFullName, boolean repeated) {
            this.fieldName = fieldName;
            this.typeFullName = typeFullName;
            this.repeated = repeated;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getTypeFullName() {
            return this.typeFullName;
        }

        public boolean isRepeated() {
            return this.repeated;
        }

        public String toString() {
            return "{fieldName='" + this.fieldName + '\'' + ", typeName='" + this.typeFullName + '\'' + '}';
        }
    }
}

