/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.SyncInvocationStage;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.util.KeyValuePair;

final class ProtobufMetadataManagerInterceptor
extends BaseCustomAsyncInterceptor {
    private static final Log log = (Log)LogFactory.getLog(ProtobufMetadataManagerInterceptor.class, Log.class);
    private static final Metadata DEFAULT_METADATA = new EmbeddedMetadata.Builder().build();
    private CommandsFactory commandsFactory;
    private ComponentRef<AsyncInterceptorChain> invoker;
    private SerializationContext serializationContext;
    private KeyPartitioner keyPartitioner;
    private SerializationContextRegistry serializationContextRegistry;
    private static final FileDescriptorSource.ProgressCallback EMPTY_CALLBACK = new FileDescriptorSource.ProgressCallback(){};
    private final AbstractVisitor serializationContextUpdaterVisitor = new AbstractVisitor(){

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
            String key = (String)command.getKey();
            if (ProtobufMetadataManagerInterceptor.this.shouldIntercept(key)) {
                ProtobufMetadataManagerInterceptor.this.registerProtoFile(key, (String)command.getValue());
            }
            return null;
        }

        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
            Map map = command.getMap();
            FileDescriptorSource source = new FileDescriptorSource().withProgressCallback(EMPTY_CALLBACK);
            FileDescriptorSource ctxRegistrySource = new FileDescriptorSource();
            for (Object key : map.keySet()) {
                if (!ProtobufMetadataManagerInterceptor.this.shouldIntercept(key)) continue;
                source.addProtoFile((String)key, (String)map.get(key));
                ctxRegistrySource.addProtoFile((String)key, (String)map.get(key));
            }
            try {
                ProtobufMetadataManagerInterceptor.this.serializationContext.registerProtoFiles(source);
                ProtobufMetadataManagerInterceptor.this.registerWithContextRegistry(ctxRegistrySource);
            }
            catch (DescriptorParserException e) {
                throw log.failedToParseProtoFile(e);
            }
            return null;
        }

        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
            String key = (String)command.getKey();
            if (ProtobufMetadataManagerInterceptor.this.shouldIntercept(key)) {
                ProtobufMetadataManagerInterceptor.this.registerProtoFile(key, (String)command.getNewValue());
            }
            return null;
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
            String key = (String)command.getKey();
            if (ProtobufMetadataManagerInterceptor.this.shouldIntercept(key) && ProtobufMetadataManagerInterceptor.this.serializationContext.getFileDescriptors().containsKey(key)) {
                ProtobufMetadataManagerInterceptor.this.serializationContext.unregisterProtoFile(key);
            }
            return null;
        }

        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
            for (String fileName : ProtobufMetadataManagerInterceptor.this.serializationContext.getFileDescriptors().keySet()) {
                ProtobufMetadataManagerInterceptor.this.serializationContext.unregisterProtoFile(fileName);
            }
            return null;
        }
    };

    ProtobufMetadataManagerInterceptor() {
    }

    private void registerProtoFile(String name, String content) {
        this.registerProtoFile(name, content, EMPTY_CALLBACK);
    }

    private void registerProtoFile(String name, String content, FileDescriptorSource.ProgressCallback callback) {
        try {
            this.serializationContext.registerProtoFiles(new FileDescriptorSource().withProgressCallback(callback).addProtoFile(name, content));
            this.registerWithContextRegistry(new FileDescriptorSource().addProtoFile(name, content));
        }
        catch (DescriptorParserException e) {
            if (name == null) {
                throw log.failedToParseProtoFile(e);
            }
            throw log.failedToParseProtoFile(name, e);
        }
    }

    private void registerWithContextRegistry(FileDescriptorSource source) {
        try {
            this.serializationContextRegistry.addProtoFile(SerializationContextRegistry.MarshallerType.GLOBAL, source);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject
    public void init(CommandsFactory commandsFactory, ComponentRef<AsyncInterceptorChain> invoker, KeyPartitioner keyPartitioner, ProtobufMetadataManager protobufMetadataManager, SerializationContextRegistry serializationContextRegistry) {
        this.commandsFactory = commandsFactory;
        this.invoker = invoker;
        this.keyPartitioner = keyPartitioner;
        this.serializationContext = ((ProtobufMetadataManagerImpl)protobufMetadataManager).getSerializationContext();
        this.serializationContextRegistry = serializationContextRegistry;
    }

    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) {
        return this.invokeNextThenAccept((InvocationContext)ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
            if (!rCtx.isOriginLocal()) {
                for (WriteCommand wc : rCommand.getModifications()) {
                    wc.acceptVisitor(rCtx, (Visitor)this.serializationContextUpdaterVisitor);
                }
            }
        });
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        InvocationStage stage;
        Object key = command.getKey();
        if (!(key instanceof String)) {
            throw log.keyMustBeString(key.getClass());
        }
        if (!this.shouldIntercept(key)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        if (ctx.isOriginLocal() && !command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER | FlagBitSets.SKIP_LOCKING)) {
            if (!((String)key).endsWith(".proto")) {
                throw log.keyMustBeStringEndingWithProto(key);
            }
            LockControlCommand cmd = this.commandsFactory.buildLockControlCommand((Object)".errors", command.getFlagsBitSet(), null);
            stage = ((AsyncInterceptorChain)this.invoker.running()).invokeStage(ctx, (VisitableCommand)cmd);
        } else {
            stage = SyncInvocationStage.completedNullStage();
        }
        return ProtobufMetadataManagerInterceptor.makeStage((Object)this.asyncInvokeNext(ctx, (VisitableCommand)command, stage)).thenApply(ctx, (VisitableCommand)command, this::handlePutKeyValueResult);
    }

    private InvocationStage handlePutKeyValueResult(InvocationContext ctx, PutKeyValueCommand putKeyValueCommand, Object rv) {
        if (putKeyValueCommand.isSuccessful()) {
            Object key = putKeyValueCommand.getKey();
            Object value = ctx.lookupEntry(key).getValue();
            if (!(value instanceof String)) {
                throw log.valueMustBeString(value.getClass());
            }
            long flagsBitSet = this.copyFlags((FlagAffectedCommand)putKeyValueCommand);
            if (ctx.isOriginLocal() && !putKeyValueCommand.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER)) {
                ProgressCallback progressCallback = new ProgressCallback();
                this.registerProtoFile((String)key, (String)value, progressCallback);
                List<KeyValuePair<String, String>> errorUpdates = this.computeErrorUpdates(progressCallback);
                InvocationStage updateStage = this.updateSchemaErrorsIterator(ctx, flagsBitSet, errorUpdates.iterator());
                return ProtobufMetadataManagerInterceptor.makeStage((Object)updateStage.thenReturn(ctx, (VisitableCommand)putKeyValueCommand, rv));
            }
            this.registerProtoFile((String)key, (String)value);
        }
        return ProtobufMetadataManagerInterceptor.makeStage((Object)rv);
    }

    List<KeyValuePair<String, String>> computeErrorUpdates(ProgressCallback progressCallback) {
        ArrayList<KeyValuePair<String, String>> errorUpdates = new ArrayList<KeyValuePair<String, String>>();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, DescriptorParserException> errorEntry : progressCallback.getErrorFiles().entrySet()) {
            String fdName = errorEntry.getKey();
            String errorValue = errorEntry.getValue().getMessage();
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(fdName);
            errorUpdates.add((KeyValuePair<String, String>)KeyValuePair.of((Object)fdName, (Object)errorValue));
        }
        for (String successKeyName : progressCallback.getSuccessFiles()) {
            errorUpdates.add(KeyValuePair.of((Object)successKeyName, null));
        }
        errorUpdates.add(KeyValuePair.of((Object)"", (Object)(sb.length() > 0 ? sb.toString() : null)));
        return errorUpdates;
    }

    private long copyFlags(FlagAffectedCommand command) {
        return command.getFlagsBitSet() | FlagBitSets.IGNORE_RETURN_VALUES & (FlagBitSets.SKIP_CACHE_STORE ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        Map map = command.getMap();
        FileDescriptorSource ctxRegistrySource = new FileDescriptorSource();
        FileDescriptorSource source = new FileDescriptorSource();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (!(key instanceof String)) {
                throw log.keyMustBeString(key.getClass());
            }
            if (!(value instanceof String)) {
                throw log.valueMustBeString(value.getClass());
            }
            if (!this.shouldIntercept(key)) continue;
            if (!((String)key).endsWith(".proto")) {
                throw log.keyMustBeStringEndingWithProto(key);
            }
            source.addProtoFile((String)key, (String)value);
            ctxRegistrySource.addProtoFile((String)key, (String)value);
        }
        LockControlCommand cmd = this.commandsFactory.buildLockControlCommand((Object)".errors", command.getFlagsBitSet(), null);
        InvocationStage stage = ((AsyncInterceptorChain)this.invoker.running()).invokeStage(ctx, (VisitableCommand)cmd);
        return ProtobufMetadataManagerInterceptor.makeStage((Object)this.asyncInvokeNext(ctx, (VisitableCommand)command, stage)).thenApply(ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
            long flagsBitSet = this.copyFlags((FlagAffectedCommand)rCommand);
            ProgressCallback progressCallback = null;
            if (rCtx.isOriginLocal()) {
                progressCallback = new ProgressCallback();
                source.withProgressCallback((FileDescriptorSource.ProgressCallback)progressCallback);
            } else {
                source.withProgressCallback(EMPTY_CALLBACK);
            }
            try {
                this.serializationContext.registerProtoFiles(source);
                this.registerWithContextRegistry(ctxRegistrySource);
            }
            catch (DescriptorParserException e) {
                throw log.failedToParseProtoFile(e);
            }
            if (progressCallback != null) {
                List<KeyValuePair<String, String>> errorUpdates = this.computeErrorUpdates(progressCallback);
                return this.updateSchemaErrorsIterator(rCtx, flagsBitSet, errorUpdates.iterator());
            }
            return InvocationStage.completedNullStage();
        });
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        if (!(command.getKey() instanceof String)) {
            throw log.keyMustBeString(command.getKey().getClass());
        }
        String key = (String)command.getKey();
        if (!this.shouldIntercept(key)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        long flagsBitSet = this.copyFlags((FlagAffectedCommand)command);
        LockControlCommand lockCommand = this.commandsFactory.buildLockControlCommand((Object)".errors", flagsBitSet, null);
        InvocationStage stage = ((AsyncInterceptorChain)this.invoker.running()).invokeStage(ctx, (VisitableCommand)lockCommand);
        stage = stage.thenApplyMakeStage(ctx, (VisitableCommand)command, (rCtx, rCommand, __) -> {
            if (this.serializationContext.getFileDescriptors().containsKey(key)) {
                this.serializationContext.unregisterProtoFile(key);
            }
            List<KeyValuePair<String, String>> errorUpdates = this.computeErrorUpdatesAfterRemove(key);
            return this.updateSchemaErrorsIterator(rCtx, flagsBitSet, errorUpdates.iterator());
        });
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, stage);
    }

    private List<KeyValuePair<String, String>> computeErrorUpdatesAfterRemove(String key) {
        ArrayList<KeyValuePair<String, String>> errorUpdates = new ArrayList<KeyValuePair<String, String>>();
        errorUpdates.add(KeyValuePair.of((Object)key, null));
        StringBuilder sb = new StringBuilder();
        for (FileDescriptor fd : this.serializationContext.getFileDescriptors().values()) {
            String fdName = fd.getName();
            if (fd.isResolved()) {
                errorUpdates.add((KeyValuePair<String, String>)KeyValuePair.of((Object)fdName, null));
                continue;
            }
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(fdName);
            errorUpdates.add((KeyValuePair<String, String>)KeyValuePair.of((Object)fdName, (Object)"One of the imported files is missing or has errors"));
        }
        errorUpdates.add(KeyValuePair.of((Object)"", (Object)(sb.length() > 0 ? sb.toString() : null)));
        return errorUpdates;
    }

    private InvocationStage updateSchemaErrorsIterator(InvocationContext ctx, long flagsBitSet, Iterator<KeyValuePair<String, String>> iterator) {
        RemoveCommand writeCommand;
        if (!iterator.hasNext()) {
            return InvocationStage.completedNullStage();
        }
        KeyValuePair<String, String> keyErrorPair = iterator.next();
        String errorsKey = (String)keyErrorPair.getKey() + ".errors";
        String errorsValue = (String)keyErrorPair.getValue();
        int segment = this.keyPartitioner.getSegment((Object)errorsKey);
        if (errorsValue == null) {
            writeCommand = this.commandsFactory.buildRemoveCommand((Object)errorsKey, null, segment, flagsBitSet);
        } else {
            PutKeyValueCommand put = this.commandsFactory.buildPutKeyValueCommand((Object)errorsKey, (Object)errorsValue, segment, DEFAULT_METADATA, flagsBitSet);
            put.setPutIfAbsent(true);
            writeCommand = put;
        }
        InvocationStage stage = ((AsyncInterceptorChain)this.invoker.running()).invokeStage(ctx, (VisitableCommand)writeCommand);
        return stage.thenApplyMakeStage(ctx, (VisitableCommand)writeCommand, (rCtx, rCommand, rv) -> this.updateSchemaErrorsIterator(rCtx, flagsBitSet, iterator));
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
        Object key = command.getKey();
        Object value = command.getNewValue();
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        if (!(key instanceof String)) {
            throw log.keyMustBeString(key.getClass());
        }
        if (!(value instanceof String)) {
            throw log.valueMustBeString(value.getClass());
        }
        if (!this.shouldIntercept(key)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        if (!((String)key).endsWith(".proto")) {
            throw log.keyMustBeStringEndingWithProto(key);
        }
        LockControlCommand cmd = this.commandsFactory.buildLockControlCommand((Object)".errors", command.getFlagsBitSet(), null);
        InvocationStage stage = ((AsyncInterceptorChain)this.invoker.running()).invokeStage(ctx, (VisitableCommand)cmd);
        return ProtobufMetadataManagerInterceptor.makeStage((Object)this.asyncInvokeNext(ctx, (VisitableCommand)command, stage)).thenApply(ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
            if (rCommand.isSuccessful()) {
                long flagsBitSet = this.copyFlags((FlagAffectedCommand)rCommand);
                if (rCtx.isOriginLocal()) {
                    ProgressCallback progressCallback = new ProgressCallback();
                    this.registerProtoFile((String)key, (String)value, progressCallback);
                    List<KeyValuePair<String, String>> errorUpdates = this.computeErrorUpdates(progressCallback);
                    return this.updateSchemaErrorsIterator(rCtx, flagsBitSet, errorUpdates.iterator());
                }
                this.registerProtoFile((String)key, (String)value);
            }
            return InvocationStage.completedNullStage();
        });
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
        for (String fileName : this.serializationContext.getFileDescriptors().keySet()) {
            this.serializationContext.unregisterProtoFile(fileName);
        }
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    private boolean shouldIntercept(Object key) {
        return !((String)key).endsWith(".errors");
    }

    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) {
        return this.handleUnsupportedCommand((ReplicableCommand)command);
    }

    private Object handleUnsupportedCommand(ReplicableCommand command) {
        throw log.cacheDoesNotSupportCommand("___protobuf_metadata", command.getClass().getName());
    }

    private static final class ProgressCallback
    implements FileDescriptorSource.ProgressCallback {
        private final Map<String, DescriptorParserException> errorFiles = new TreeMap<String, DescriptorParserException>();
        private final Set<String> successFiles = new TreeSet<String>();

        private ProgressCallback() {
        }

        Map<String, DescriptorParserException> getErrorFiles() {
            return this.errorFiles;
        }

        public Set<String> getSuccessFiles() {
            return this.successFiles;
        }

        public void handleError(String fileName, DescriptorParserException exception) {
            this.errorFiles.putIfAbsent(fileName, exception);
        }

        public void handleSuccess(String fileName) {
            this.successFiles.add(fileName);
        }
    }
}

