package org.infinispan.query.remote.impl.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-09-28T04:34:21-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String queryingNotEnabled = "ISPN028004: Querying is not enabled on cache %s";
    protected String queryingNotEnabled$str() {
        return queryingNotEnabled;
    }
    @Override
    public final CacheException queryingNotEnabled(final String cacheName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), queryingNotEnabled$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyMustBeString = "ISPN028007: The key must be a String : %s";
    protected String keyMustBeString$str() {
        return keyMustBeString;
    }
    @Override
    public final CacheException keyMustBeString(final Class<?> c) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), keyMustBeString$str(), c));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String valueMustBeString = "ISPN028008: The value must be a String : %s";
    protected String valueMustBeString$str() {
        return valueMustBeString;
    }
    @Override
    public final CacheException valueMustBeString(final Class<?> c) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), valueMustBeString$str(), c));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyMustBeStringEndingWithProto = "ISPN028009: The key must be a String ending with \".proto\" : %s";
    protected String keyMustBeStringEndingWithProto$str() {
        return keyMustBeStringEndingWithProto;
    }
    @Override
    public final CacheException keyMustBeStringEndingWithProto(final Object key) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), keyMustBeStringEndingWithProto$str(), key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToParseProtoFile0 = "ISPN028010: Failed to parse proto file.";
    protected String failedToParseProtoFile0$str() {
        return failedToParseProtoFile0;
    }
    @Override
    public final CacheException failedToParseProtoFile(final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), failedToParseProtoFile0$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToParseProtoFile1 = "ISPN028011: Failed to parse proto file : %s";
    protected String failedToParseProtoFile1$str() {
        return failedToParseProtoFile1;
    }
    @Override
    public final CacheException failedToParseProtoFile(final String fileName, final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), failedToParseProtoFile1$str(), fileName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorInitializingSerCtx = "ISPN028013: Error during execution of protostream serialization context initializer";
    protected String errorInitializingSerCtx$str() {
        return errorInitializingSerCtx;
    }
    @Override
    public final CacheException errorInitializingSerCtx(final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), errorInitializingSerCtx$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheDoesNotSupportCommand = "ISPN028014: The '%s' cache does not support commands of type %s";
    protected String cacheDoesNotSupportCommand$str() {
        return cacheDoesNotSupportCommand;
    }
    @Override
    public final CacheException cacheDoesNotSupportCommand(final String cacheName, final String commandType) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheDoesNotSupportCommand$str(), cacheName, commandType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheNotQueryable = "ISPN028015: Cache '%s' with storage type '%s' cannot be queried. Please configure the cache encoding as 'application/x-protostream' or 'application/x-java-object'";
    protected String cacheNotQueryable$str() {
        return cacheNotQueryable;
    }
    @Override
    public final CacheException cacheNotQueryable(final String cacheName, final String storage) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheNotQueryable$str(), cacheName, storage));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void warnNoMediaType(final String cacheName) {
        super.log.logf(FQCN, WARN, null, warnNoMediaType$str(), cacheName);
    }
    private static final String warnNoMediaType = "ISPN028016: Query performed in a cache ('%s') that has an unknown format configuration. Please configure the cache encoding as 'application/x-protostream' or 'application/x-java-object'";
    protected String warnNoMediaType$str() {
        return warnNoMediaType;
    }
    private static final String fieldTypeNotIndexable = "ISPN028018: It is not possible to create indexes for a field having type %s. Field: %s.";
    protected String fieldTypeNotIndexable$str() {
        return fieldTypeNotIndexable;
    }
    @Override
    public final CacheException fieldTypeNotIndexable(final String typeName, final String fieldName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), fieldTypeNotIndexable$str(), typeName, fieldName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String typeNotIndexed = "ISPN028021: The configured indexed-entity type '%s' must be indexed. Please annotate it with @Indexed and make sure at least one field has the @Field annotation, or remove it from the configuration.";
    protected String typeNotIndexed$str() {
        return typeNotIndexed;
    }
    @Override
    public final CacheConfigurationException typeNotIndexed(final String typeName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), typeNotIndexed$str(), typeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownType = "ISPN028022: The declared indexed type '%s' is not known. Please register its proto schema file first";
    protected String unknownType$str() {
        return unknownType;
    }
    @Override
    public final CacheConfigurationException unknownType(final String typeName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownType$str(), typeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
