/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.query.remote.json.JsonProjection;
import org.infinispan.query.remote.json.JsonQueryResponse;

public class ProjectedJsonResult
extends JsonQueryResponse {
    private final List<JsonProjection> hits;

    public ProjectedJsonResult(long totalResults, String[] projections, List<Object> values) {
        super(totalResults);
        this.hits = new ArrayList<JsonProjection>(projections.length);
        for (Object v : values) {
            Object[] result = (Object[])v;
            HashMap<String, Object> p = new HashMap<String, Object>();
            for (int i = 0; i < projections.length; ++i) {
                p.put(projections[i], result[i]);
            }
            this.hits.add(new JsonProjection(p));
        }
    }

    public List<JsonProjection> getHits() {
        return this.hits;
    }

    public Json toJson() {
        Json object = Json.object();
        object.set("total_results", (Object)this.getTotalResults());
        Json array = Json.array();
        this.hits.forEach(h -> array.add(Json.factory().raw(h.toJson().toString())));
        return object.set("hits", array);
    }
}

