/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.query.remote.client.impl.QueryRequest;
import org.infinispan.query.remote.client.impl.QueryResponse;
import org.infinispan.query.remote.impl.QuerySerializer;
import org.infinispan.query.remote.impl.RemoteQueryManager;
import org.infinispan.query.remote.impl.RemoteQueryResult;

class DefaultQuerySerializer
implements QuerySerializer<QueryResponse> {
    private final EncoderRegistry encoderRegistry;

    DefaultQuerySerializer(EncoderRegistry encoderRegistry) {
        this.encoderRegistry = encoderRegistry;
    }

    @Override
    public QueryRequest decodeQueryRequest(byte[] queryRequest, MediaType mediaType) {
        if (mediaType.match(MediaType.APPLICATION_PROTOSTREAM)) {
            mediaType = RemoteQueryManager.PROTOSTREAM_UNWRAPPED;
        }
        Transcoder transcoder = this.encoderRegistry.getTranscoder(MediaType.APPLICATION_OBJECT, mediaType);
        return (QueryRequest)transcoder.transcode((Object)queryRequest, mediaType, RemoteQueryManager.QUERY_REQUEST_TYPE);
    }

    @Override
    public QueryResponse createQueryResponse(RemoteQueryResult remoteQueryResult) {
        List<Object> list = remoteQueryResult.getResults();
        int numResults = list.size();
        String[] projection = remoteQueryResult.getProjections();
        int projSize = projection != null ? projection.length : 0;
        ArrayList<WrappedMessage> results = new ArrayList<WrappedMessage>(projSize == 0 ? numResults : numResults * projSize);
        for (Object o : list) {
            if (projSize == 0) {
                results.add(new WrappedMessage(o));
                continue;
            }
            Object[] row = (Object[])o;
            for (int i = 0; i < projSize; ++i) {
                results.add(new WrappedMessage(row[i]));
            }
        }
        QueryResponse response = new QueryResponse();
        response.setTotalResults(remoteQueryResult.getTotalResults());
        response.setNumResults(numResults);
        response.setProjectionSize(projSize);
        response.setResults(results);
        return response;
    }

    @Override
    public byte[] encodeQueryResponse(Object queryResponse, MediaType destinationType) {
        MediaType destination = destinationType;
        if (destinationType.match(MediaType.APPLICATION_PROTOSTREAM)) {
            destination = RemoteQueryManager.PROTOSTREAM_UNWRAPPED;
        }
        Transcoder transcoder = this.encoderRegistry.getTranscoder(MediaType.APPLICATION_OBJECT, destinationType);
        return (byte[])transcoder.transcode(queryResponse, MediaType.APPLICATION_OBJECT, destination);
    }
}

