/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import javax.management.MBeanException;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.UserContextInitializerImpl;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.types.java.CommonContainerTypesSchema;
import org.infinispan.protostream.types.java.CommonTypesSchema;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.client.impl.MarshallerRegistration;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerInterceptor;
import org.infinispan.query.remote.impl.SecurityActions;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.security.Role;
import org.infinispan.security.impl.CreatePermissionConfigurationBuilder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;

@MBean(objectName="ProtobufMetadataManager", description="Component that acts as a manager and persistent container for Protocol Buffers schema definitions in the scope of a CacheManger.")
@Scope(value=Scopes.GLOBAL)
public final class ProtobufMetadataManagerImpl
implements ProtobufMetadataManager {
    private static final Log log = (Log)LogFactory.getLog(ProtobufMetadataManagerImpl.class, Log.class);
    private final SerializationContext serCtx;
    private volatile Cache<String, String> protobufSchemaCache;
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    InternalCacheRegistry internalCacheRegistry;
    @Inject
    SerializationContextRegistry serializationContextRegistry;

    public ProtobufMetadataManagerImpl() {
        Configuration.Builder protostreamCfgBuilder = Configuration.builder();
        IndexingMetadata.configure(protostreamCfgBuilder);
        this.serCtx = ProtobufUtil.newSerializationContext((Configuration)protostreamCfgBuilder.build());
        try {
            MarshallerRegistration.init((SerializationContext)this.serCtx);
        }
        catch (DescriptorParserException e) {
            throw new CacheException("Failed to initialise the Protobuf serialization context", (Throwable)e);
        }
        this.register((SerializationContextInitializer)new CommonTypesSchema());
        this.register((SerializationContextInitializer)new CommonContainerTypesSchema());
        this.register((SerializationContextInitializer)new UserContextInitializerImpl());
    }

    void register(SerializationContextInitializer initializer) {
        initializer.registerSchema(this.getSerializationContext());
        initializer.registerMarshallers(this.getSerializationContext());
    }

    @Start
    void start() {
        GlobalConfiguration globalConfiguration = this.cacheManager.getCacheManagerConfiguration();
        this.internalCacheRegistry.registerInternalCache("___protobuf_metadata", ProtobufMetadataManagerImpl.getProtobufMetadataCacheConfig(globalConfiguration).build(), EnumSet.of(InternalCacheRegistry.Flag.USER, InternalCacheRegistry.Flag.PROTECTED, InternalCacheRegistry.Flag.PERSISTENT));
        Collection initializers = globalConfiguration.serialization().contextInitializers();
        if (initializers == null || initializers.isEmpty()) {
            initializers = ServiceFinder.load(SerializationContextInitializer.class, (ClassLoader[])new ClassLoader[]{globalConfiguration.classLoader()});
        }
        this.processSerializationContextInitializer(initializers);
    }

    private void processSerializationContextInitializer(Iterable<SerializationContextInitializer> initializers) {
        if (initializers != null) {
            for (SerializationContextInitializer sci : initializers) {
                log.debugf("Registering protostream serialization context initializer: %s", sci.getClass().getName());
                try {
                    sci.registerSchema(this.serCtx);
                    sci.registerMarshallers(this.serCtx);
                }
                catch (Exception e) {
                    throw log.errorInitializingSerCtx(e);
                }
            }
        }
    }

    void addProtobufMetadataManagerInterceptor(BasicComponentRegistry cacheComponentRegistry) {
        ProtobufMetadataManagerInterceptor interceptor = new ProtobufMetadataManagerInterceptor();
        cacheComponentRegistry.registerComponent(ProtobufMetadataManagerInterceptor.class, (Object)interceptor, true);
        cacheComponentRegistry.addDynamicDependency(AsyncInterceptorChain.class.getName(), ProtobufMetadataManagerInterceptor.class.getName());
        ((AsyncInterceptorChain)cacheComponentRegistry.getComponent(AsyncInterceptorChain.class).wired()).addInterceptorAfter((AsyncInterceptor)interceptor, EntryWrappingInterceptor.class);
    }

    void addCacheDependency(String dependantCacheName) {
        SecurityActions.addCacheDependency(this.cacheManager, dependantCacheName, "___protobuf_metadata");
    }

    public Cache<String, String> getCache() {
        if (this.protobufSchemaCache == null) {
            Cache unwrappedCache = SecurityActions.getUnwrappedCache(this.cacheManager, "___protobuf_metadata");
            this.protobufSchemaCache = unwrappedCache.getAdvancedCache();
        }
        return this.protobufSchemaCache;
    }

    private static ConfigurationBuilder getProtobufMetadataCacheConfig(GlobalConfiguration globalConfiguration) {
        CacheMode cacheMode = globalConfiguration.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL;
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).invocationBatching().enable().transaction().lockingMode(LockingMode.PESSIMISTIC).locking().isolationLevel(IsolationLevel.READ_COMMITTED).useLockStriping(false).clustering().cacheMode(cacheMode).stateTransfer().fetchInMemoryState(true).awaitInitialTransfer(false).encoding().key().mediaType("application/x-java-object").encoding().value().mediaType("application/x-java-object");
        GlobalAuthorizationConfiguration globalAuthz = globalConfiguration.security().authorization();
        if (globalAuthz.enabled()) {
            if (!globalAuthz.hasRole("___schema_manager")) {
                globalAuthz.addRole((Role)GlobalAuthorizationConfiguration.DEFAULT_ROLES.get("___schema_manager"));
            }
            AuthorizationConfigurationBuilder authorization = cfg.security().authorization().enable();
            globalAuthz.roles().keySet().forEach(role -> authorization.role(role));
            cfg.addModule(CreatePermissionConfigurationBuilder.class);
        }
        return cfg;
    }

    @Override
    public void registerMarshaller(BaseMarshaller<?> marshaller) {
        this.serCtx.registerMarshaller(marshaller);
        this.serializationContextRegistry.addMarshaller(SerializationContextRegistry.MarshallerType.GLOBAL, marshaller);
    }

    @Override
    public void unregisterMarshaller(BaseMarshaller<?> marshaller) {
        this.serCtx.unregisterMarshaller(marshaller);
    }

    @ManagedOperation(description="Registers a Protobuf definition file", displayName="Register a Protofile")
    public void registerProtofile(@Parameter(name="fileName", description="the name of the .proto file") String fileName, @Parameter(name="contents", description="contents of the file") String contents) {
        this.getCache().put((Object)fileName, (Object)contents);
    }

    @ManagedOperation(description="Registers multiple Protobuf definition files", displayName="Register Protofiles")
    public void registerProtofiles(@Parameter(name="fileNames", description="names of the protofiles") String[] fileNames, @Parameter(name="fileContents", description="content of the files") String[] contents) throws Exception {
        if (fileNames.length != contents.length) {
            throw new MBeanException(new IllegalArgumentException("invalid parameter sizes"));
        }
        HashMap<String, String> files = new HashMap<String, String>(fileNames.length);
        for (int i = 0; i < fileNames.length; ++i) {
            files.put(fileNames[i], contents[i]);
        }
        this.getCache().putAll(files);
    }

    @ManagedOperation(description="Unregisters a Protobuf definition files", displayName="Unregister a Protofiles")
    public void unregisterProtofile(@Parameter(name="fileName", description="the name of the .proto file") String fileName) {
        if (this.getCache().remove((Object)fileName) == null) {
            throw new IllegalArgumentException("File does not exist : " + fileName);
        }
    }

    @ManagedOperation(description="Unregisters multiple Protobuf definition files", displayName="Unregister Protofiles")
    public void unregisterProtofiles(@Parameter(name="fileNames", description="names of the protofiles") String[] fileNames) {
        for (String fileName : fileNames) {
            if (this.getCache().remove((Object)fileName) != null) continue;
            throw new IllegalArgumentException("File does not exist : " + fileName);
        }
    }

    @ManagedAttribute(description="The names of all Protobuf files", displayName="Protofile Names")
    public String[] getProtofileNames() {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String k : this.getCache().keySet()) {
            if (!k.endsWith(".proto")) continue;
            fileNames.add(k);
        }
        Collections.sort(fileNames);
        return fileNames.toArray(new String[fileNames.size()]);
    }

    @ManagedOperation(description="Get the contents of a protobuf definition file", displayName="Get Protofile")
    public String getProtofile(@Parameter(name="fileName", description="the name of the .proto file") String fileName) {
        if (!fileName.endsWith(".proto")) {
            throw new IllegalArgumentException("The file name must have \".proto\" suffix");
        }
        String fileContents = (String)this.getCache().get((Object)fileName);
        if (fileContents == null) {
            throw new IllegalArgumentException("File does not exist : " + fileName);
        }
        return fileContents;
    }

    @ManagedAttribute(description="The names of the files that have errors, if any", displayName="Files With Errors")
    public String[] getFilesWithErrors() {
        String filesWithErrors = (String)this.getCache().get((Object)".errors");
        if (filesWithErrors == null) {
            return null;
        }
        Object[] fileNames = filesWithErrors.split("\n");
        Arrays.sort(fileNames);
        return fileNames;
    }

    @ManagedOperation(description="Obtains the errors associated with a protobuf definition file", displayName="Get Errors For A File")
    public String getFileErrors(@Parameter(name="fileName", description="the name of the .proto file") String fileName) {
        if (!fileName.endsWith(".proto")) {
            throw new IllegalArgumentException("The file name must have \".proto\" suffix");
        }
        if (!this.getCache().containsKey((Object)fileName)) {
            throw new IllegalArgumentException("File does not exist : " + fileName);
        }
        return (String)this.getCache().get((Object)(fileName + ".errors"));
    }

    SerializationContext getSerializationContext() {
        return this.serCtx;
    }

    private static ProtobufMetadataManagerImpl getProtobufMetadataManager(EmbeddedCacheManager cacheManager) {
        if (cacheManager == null) {
            throw new IllegalArgumentException("cacheManager cannot be null");
        }
        ProtobufMetadataManagerImpl metadataManager = (ProtobufMetadataManagerImpl)cacheManager.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        if (metadataManager == null) {
            throw new IllegalStateException("ProtobufMetadataManager not initialised yet!");
        }
        return metadataManager;
    }

    public static SerializationContext getSerializationContext(EmbeddedCacheManager cacheManager) {
        return ProtobufMetadataManagerImpl.getProtobufMetadataManager(cacheManager).getSerializationContext();
    }
}

