package org.infinispan.query.remote.impl.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2023-01-19T03:21:04-0500")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String queryingNotEnabled$str() {
        return "ISPN028004: Querying is not enabled on cache %s";
    }
    @Override
    public final CacheException queryingNotEnabled(final String cacheName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), queryingNotEnabled$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String keyMustBeString$str() {
        return "ISPN028007: The key must be a String : %s";
    }
    @Override
    public final CacheException keyMustBeString(final Class<?> c) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), keyMustBeString$str(), c));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String valueMustBeString$str() {
        return "ISPN028008: The value must be a String : %s";
    }
    @Override
    public final CacheException valueMustBeString(final Class<?> c) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), valueMustBeString$str(), c));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keyMustBeStringEndingWithProto$str() {
        return "ISPN028009: The key must be a String ending with \".proto\" : %s";
    }
    @Override
    public final CacheException keyMustBeStringEndingWithProto(final Object key) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), keyMustBeStringEndingWithProto$str(), key));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToParseProtoFile0$str() {
        return "ISPN028010: Failed to parse proto file.";
    }
    @Override
    public final CacheException failedToParseProtoFile(final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), failedToParseProtoFile0$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToParseProtoFile1$str() {
        return "ISPN028011: Failed to parse proto file : %s";
    }
    @Override
    public final CacheException failedToParseProtoFile(final String fileName, final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), failedToParseProtoFile1$str(), fileName), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorInitializingSerCtx$str() {
        return "ISPN028013: Error during execution of protostream serialization context initializer";
    }
    @Override
    public final CacheException errorInitializingSerCtx(final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), errorInitializingSerCtx$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheDoesNotSupportCommand$str() {
        return "ISPN028014: The '%s' cache does not support commands of type %s";
    }
    @Override
    public final CacheException cacheDoesNotSupportCommand(final String cacheName, final String commandType) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheDoesNotSupportCommand$str(), cacheName, commandType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheNotQueryable$str() {
        return "ISPN028015: Cache '%s' with storage type '%s' cannot be queried. Please configure the cache encoding as 'application/x-protostream' or 'application/x-java-object'";
    }
    @Override
    public final CacheException cacheNotQueryable(final String cacheName, final String storage) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheNotQueryable$str(), cacheName, storage));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void warnNoMediaType(final String cacheName) {
        super.log.logf(FQCN, WARN, null, warnNoMediaType$str(), cacheName);
    }
    protected String warnNoMediaType$str() {
        return "ISPN028016: Query performed in a cache ('%s') that has an unknown format configuration. Please configure the cache encoding as 'application/x-protostream' or 'application/x-java-object'";
    }
    protected String fieldTypeNotIndexable$str() {
        return "ISPN028018: It is not possible to create indexes for a field having type %s. Field: %s.";
    }
    @Override
    public final CacheException fieldTypeNotIndexable(final String typeName, final String fieldName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), fieldTypeNotIndexable$str(), typeName, fieldName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String typeNotIndexed$str() {
        return "ISPN028021: The configured indexed-entity type '%s' must be indexed. Please annotate it with @Indexed and make sure at least one field has the @Field annotation, or remove it from the configuration.";
    }
    @Override
    public final CacheConfigurationException typeNotIndexed(final String typeName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), typeNotIndexed$str(), typeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownType$str() {
        return "ISPN028022: The declared indexed type '%s' is not known. Please register its proto schema file first";
    }
    @Override
    public final CacheConfigurationException unknownType(final String typeName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownType$str(), typeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
