/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.mapping.reference;

import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeFactoryImpl;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.types.Aggregable;
import org.hibernate.search.engine.backend.types.Norms;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.TermVector;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFinalStep;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeOptionsStep;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.logging.Log;

public class FieldReferenceProvider {
    private static final Log log = (Log)LogFactory.getLog(FieldReferenceProvider.class, Log.class);
    private final String name;
    private final Type type;
    private final boolean repeated;
    private final Searchable searchable;
    private final Projectable projectable;
    private final Aggregable aggregable;
    private final Sortable sortable;
    private final String analyzer;
    private final String normalizer;
    private final Object indexNullAs;
    private final Norms norms;
    private final String searchAnalyzer;
    private final TermVector termVector;
    private final Integer decimalScale;

    public FieldReferenceProvider(FieldDescriptor fieldDescriptor, FieldMapping fieldMapping) {
        this.name = fieldDescriptor.getName();
        this.type = fieldDescriptor.getType();
        this.repeated = fieldDescriptor.isRepeated();
        this.searchable = fieldMapping.searchable() ? Searchable.YES : Searchable.NO;
        this.projectable = fieldMapping.projectable() ? Projectable.YES : Projectable.NO;
        this.aggregable = fieldMapping.aggregable() ? Aggregable.YES : Aggregable.NO;
        this.sortable = fieldMapping.sortable() ? Sortable.YES : Sortable.NO;
        this.analyzer = fieldMapping.analyzer();
        this.normalizer = fieldMapping.normalizer();
        this.indexNullAs = fieldMapping.parseIndexNullAs();
        this.norms = fieldMapping.norms() == null ? null : (fieldMapping.norms() != false ? Norms.YES : Norms.NO);
        this.searchAnalyzer = fieldMapping.searchAnalyzer();
        this.termVector = FieldReferenceProvider.termVector(fieldMapping.termVector());
        this.decimalScale = fieldMapping.decimalScale();
    }

    private static TermVector termVector(org.infinispan.api.annotations.indexing.option.TermVector termVector) {
        if (termVector == null) {
            return null;
        }
        switch (termVector) {
            case YES: {
                return TermVector.YES;
            }
            case NO: {
                return TermVector.NO;
            }
            case WITH_POSITIONS: {
                return TermVector.WITH_POSITIONS;
            }
            case WITH_OFFSETS: {
                return TermVector.WITH_OFFSETS;
            }
            case WITH_POSITIONS_OFFSETS: {
                return TermVector.WITH_POSITIONS_OFFSETS;
            }
            case WITH_POSITIONS_PAYLOADS: {
                return TermVector.WITH_POSITIONS_PAYLOADS;
            }
            case WITH_POSITIONS_OFFSETS_PAYLOADS: {
                return TermVector.WITH_POSITIONS_OFFSETS_PAYLOADS;
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public IndexFieldReference<Object> bind(IndexSchemaElement indexSchemaElement) {
        if (this.nothingToBind()) {
            return null;
        }
        IndexSchemaFieldOptionsStep step = indexSchemaElement.field(this.name, this::bind);
        if (this.repeated) {
            step.multiValued();
        }
        return (IndexFieldReference)step.toReference();
    }

    public boolean nothingToBind() {
        return Searchable.NO.equals((Object)this.searchable) && Projectable.NO.equals((Object)this.projectable) && Aggregable.NO.equals((Object)this.aggregable) && Sortable.NO.equals((Object)this.sortable);
    }

    private <F> IndexFieldTypeFinalStep<F> bind(IndexFieldTypeFactory typeFactory) {
        StandardIndexFieldTypeOptionsStep<?, ?> optionsStep = this.bindType(typeFactory);
        optionsStep.searchable(this.searchable).sortable(this.sortable).projectable(this.projectable).aggregable(this.aggregable);
        if (this.indexNullAs != null) {
            optionsStep.indexNullAs(this.indexNullAs);
        }
        return optionsStep;
    }

    private StandardIndexFieldTypeOptionsStep<?, ?> bindType(IndexFieldTypeFactory typeFactory) {
        switch (this.type.getJavaType()) {
            case ENUM: 
            case INT: {
                return typeFactory.asInteger();
            }
            case LONG: {
                return typeFactory.asLong();
            }
            case FLOAT: {
                return typeFactory.asFloat();
            }
            case DOUBLE: {
                return typeFactory.asDouble();
            }
            case BOOLEAN: {
                return typeFactory.asBoolean();
            }
            case STRING: {
                StringIndexFieldTypeOptionsStep step = typeFactory.asString();
                this.bindStringTypeOptions(typeFactory, step);
                return step;
            }
            case BYTE_STRING: {
                return typeFactory.asString();
            }
        }
        throw log.fieldTypeNotIndexable(this.type.toString(), this.name);
    }

    private void bindStringTypeOptions(IndexFieldTypeFactory typeFactory, StringIndexFieldTypeOptionsStep<?> step) {
        this.bindNormalizerOrAnalyzer((LuceneIndexFieldTypeFactoryImpl)typeFactory, step);
        if (this.norms != null) {
            step.norms(this.norms);
        }
        if (this.searchAnalyzer != null) {
            step.searchAnalyzer(this.searchAnalyzer);
        }
        if (this.termVector != null) {
            step.termVector(this.termVector);
        }
    }

    private void bindNormalizerOrAnalyzer(LuceneIndexFieldTypeFactoryImpl typeFactory, StringIndexFieldTypeOptionsStep<?> step) {
        if (this.normalizer != null) {
            step.normalizer(this.normalizer);
            return;
        }
        if (this.analyzer == null) {
            return;
        }
        LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry = typeFactory.getAnalysisDefinitionRegistry();
        if (analysisDefinitionRegistry.getNormalizerDefinition(this.analyzer) != null) {
            step.normalizer(this.analyzer);
        } else {
            step.analyzer(this.analyzer);
        }
    }

    public String toString() {
        return "{name='" + this.name + "', type=" + this.type + "}";
    }
}

