/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.mapping.reference;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.mapping.reference.MessageReferenceProvider;

public class GlobalReferenceHolder {
    private final Map<String, MessageReferenceProvider> messageReferenceProviders = new HashMap<String, MessageReferenceProvider>();
    private final Set<RootMessageInfo> rootMessages = new LinkedHashSet<RootMessageInfo>();
    private final Map<String, Descriptor> rootDescriptors = new HashMap<String, Descriptor>();

    public GlobalReferenceHolder(Map<String, GenericDescriptor> descriptors) {
        HashSet<Descriptor> messageTypes = new HashSet<Descriptor>();
        HashSet nestedDescriptors = new HashSet();
        for (Map.Entry<String, GenericDescriptor> entry : descriptors.entrySet()) {
            Descriptor descriptor;
            MessageReferenceProvider messageReferenceProvider;
            GenericDescriptor genericDescriptor = entry.getValue();
            if (!(genericDescriptor instanceof Descriptor) || (messageReferenceProvider = new MessageReferenceProvider(descriptor = (Descriptor)genericDescriptor)).isEmpty()) continue;
            this.messageReferenceProviders.put(entry.getKey(), messageReferenceProvider);
            messageTypes.add(descriptor);
            nestedDescriptors.addAll(descriptor.getNestedTypes());
        }
        messageTypes.removeAll(nestedDescriptors);
        for (Descriptor descriptor : messageTypes) {
            this.rootMessages.add(new RootMessageInfo(descriptor));
            this.rootDescriptors.put(descriptor.getFullName(), descriptor);
        }
    }

    public Map<String, MessageReferenceProvider> getMessageReferenceProviders() {
        return this.messageReferenceProviders;
    }

    public Set<RootMessageInfo> getRootMessages() {
        return this.rootMessages;
    }

    public Descriptor getDescriptor(String fullName) {
        return this.rootDescriptors.get(fullName);
    }

    public MessageReferenceProvider messageReferenceProvider(String fullName) {
        return this.messageReferenceProviders.get(fullName);
    }

    public boolean hasKeyMapping(String fullName) {
        MessageReferenceProvider messageReferenceProvider = this.messageReferenceProvider(fullName);
        if (messageReferenceProvider == null) {
            return false;
        }
        return messageReferenceProvider.keyMessageName() != null;
    }

    public String toString() {
        return this.messageReferenceProviders.toString();
    }

    public static class RootMessageInfo {
        private final String fullName;
        private final String indexName;

        private RootMessageInfo(Descriptor descriptor) {
            IndexingMetadata indexingMetadata = (IndexingMetadata)IndexingMetadata.findProcessedAnnotation(descriptor, "Indexed");
            this.fullName = descriptor.getFullName();
            this.indexName = indexingMetadata.indexName() != null ? indexingMetadata.indexName() : this.fullName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getIndexName() {
            return this.indexName;
        }
    }
}

