/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.SyncInvocationStage;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.util.KeyValuePair;

final class ProtobufMetadataManagerInterceptor
extends BaseCustomAsyncInterceptor {
    private static final Log log = (Log)LogFactory.getLog(ProtobufMetadataManagerInterceptor.class, Log.class);
    private static final Metadata DEFAULT_METADATA = new EmbeddedMetadata.Builder().build();
    private CommandsFactory commandsFactory;
    private ComponentRef<AsyncInterceptorChain> invoker;
    private SerializationContext serializationContext;
    private KeyPartitioner keyPartitioner;
    private SerializationContextRegistry serializationContextRegistry;
    private static final FileDescriptorSource.ProgressCallback EMPTY_CALLBACK = new FileDescriptorSource.ProgressCallback(){};
    private final AbstractVisitor serializationContextUpdaterVisitor = new AbstractVisitor(){

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
            this.registerSingleProtoFile(command.getKey(), command.getValue());
            return null;
        }

        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
            Map map = command.getMap();
            FileDescriptorSource source = new FileDescriptorSource().withProgressCallback(EMPTY_CALLBACK);
            for (Object key : map.keySet()) {
                String protoKey = ProtobufMetadataManagerInterceptor.validateKey(key);
                if (ProtobufMetadataManagerInterceptor.isErrorKeySuffix(protoKey)) continue;
                String value = ProtobufMetadataManagerInterceptor.validateValue(map.get(key));
                log.debugf("Registering proto file '%s': %s", protoKey, value);
                source.addProtoFile(protoKey, value);
            }
            ProtobufMetadataManagerInterceptor.this.registerFileDescriptorSource(source, source.getFiles().keySet().toString());
            return null;
        }

        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
            this.registerSingleProtoFile(command.getKey(), command.getNewValue());
            return Boolean.TRUE;
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
            String key = ProtobufMetadataManagerInterceptor.validateKey(command.getKey());
            if (ProtobufMetadataManagerInterceptor.isErrorKeySuffix(key)) {
                return null;
            }
            ProtobufMetadataManagerInterceptor.validateKeySuffix(key);
            ProtobufMetadataManagerInterceptor.this.removeProtoFile(key);
            return null;
        }

        private void registerSingleProtoFile(Object key, Object value) {
            String protoKey = ProtobufMetadataManagerInterceptor.validateKey(key);
            if (ProtobufMetadataManagerInterceptor.isErrorKeySuffix(protoKey)) {
                return;
            }
            ProtobufMetadataManagerInterceptor.validateKeySuffix(protoKey);
            ProtobufMetadataManagerInterceptor.this.registerProtoFile(protoKey, ProtobufMetadataManagerInterceptor.validateValue(value), EMPTY_CALLBACK);
        }
    };

    ProtobufMetadataManagerInterceptor() {
    }

    private void registerProtoFile(String name, String content, FileDescriptorSource.ProgressCallback callback) {
        log.debugf("Registering proto file '%s': %s", name, content);
        FileDescriptorSource source = new FileDescriptorSource().withProgressCallback(callback).addProtoFile(name, content);
        this.registerFileDescriptorSource(source, source.getFiles().keySet().toString());
    }

    @Inject
    public void init(CommandsFactory commandsFactory, ComponentRef<AsyncInterceptorChain> invoker, KeyPartitioner keyPartitioner, ProtobufMetadataManager protobufMetadataManager, SerializationContextRegistry serializationContextRegistry) {
        this.commandsFactory = commandsFactory;
        this.invoker = invoker;
        this.keyPartitioner = keyPartitioner;
        this.serializationContext = ((ProtobufMetadataManagerImpl)protobufMetadataManager).getSerializationContext();
        this.serializationContextRegistry = serializationContextRegistry;
    }

    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) {
        return this.invokeNextThenAccept((InvocationContext)ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
            if (!rCtx.isOriginLocal()) {
                for (WriteCommand wc : rCommand.getModifications()) {
                    wc.acceptVisitor(rCtx, (Visitor)this.serializationContextUpdaterVisitor);
                }
            }
        });
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        String key = ProtobufMetadataManagerInterceptor.validateKey(command.getKey());
        if (ProtobufMetadataManagerInterceptor.isErrorKeySuffix(key)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        ProtobufMetadataManagerInterceptor.validateKeySuffix(key);
        InvocationStage stage = !command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER | FlagBitSets.SKIP_LOCKING) ? ((AsyncInterceptorChain)this.invoker.running()).invokeStage(ctx, (VisitableCommand)this.buildLockCommand(command.getFlagsBitSet())) : SyncInvocationStage.completedNullStage();
        return ProtobufMetadataManagerInterceptor.makeStage((Object)this.asyncInvokeNext(ctx, (VisitableCommand)command, stage)).thenApply(ctx, (VisitableCommand)command, this::handlePutKeyValueResult);
    }

    private InvocationStage handlePutKeyValueResult(InvocationContext ctx, PutKeyValueCommand cmd, Object rv) {
        assert (ctx.isOriginLocal());
        if (cmd.isSuccessful()) {
            String key = ProtobufMetadataManagerInterceptor.validateKey(cmd.getKey());
            String value = ProtobufMetadataManagerInterceptor.validateValue(cmd.getValue());
            if (cmd.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER)) {
                this.registerProtoFile(key, value, EMPTY_CALLBACK);
                return ProtobufMetadataManagerInterceptor.makeStage((Object)rv);
            }
            return this.handleLocalProtoFileRegister(ctx, key, value, ProtobufMetadataManagerInterceptor.copyFlags((FlagAffectedCommand)cmd));
        }
        return ProtobufMetadataManagerInterceptor.makeStage((Object)rv);
    }

    List<KeyValuePair<String, String>> computeErrorUpdates(ProgressCallback progressCallback) {
        ArrayList<KeyValuePair<String, String>> errorUpdates = new ArrayList<KeyValuePair<String, String>>();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, DescriptorParserException> errorEntry : progressCallback.getErrorFiles().entrySet()) {
            String fdName = errorEntry.getKey();
            String errorValue = errorEntry.getValue().getMessage();
            if (!sb.isEmpty()) {
                sb.append('\n');
            }
            sb.append(fdName);
            errorUpdates.add((KeyValuePair<String, String>)KeyValuePair.of((Object)fdName, (Object)errorValue));
        }
        for (String successKeyName : progressCallback.getSuccessFiles()) {
            errorUpdates.add(KeyValuePair.of((Object)successKeyName, null));
        }
        errorUpdates.add(KeyValuePair.of((Object)"", (Object)(!sb.isEmpty() ? sb.toString() : null)));
        return errorUpdates;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        InvocationStage stage = ((AsyncInterceptorChain)this.invoker.running()).invokeStage(ctx, (VisitableCommand)this.buildLockCommand(command.getFlagsBitSet()));
        return ProtobufMetadataManagerInterceptor.makeStage((Object)this.asyncInvokeNext(ctx, (VisitableCommand)command, stage)).thenApply(ctx, (VisitableCommand)command, this::handleLocalPutMapResult);
    }

    private InvocationStage handleLocalPutMapResult(InvocationContext ctx, PutMapCommand cmd, Object ignored) {
        assert (ctx.isOriginLocal());
        FileDescriptorSource source = new FileDescriptorSource();
        for (Object key : cmd.getMap().keySet()) {
            String protoKey = ProtobufMetadataManagerInterceptor.validateKey(key);
            String value = ProtobufMetadataManagerInterceptor.validateValue(cmd.getMap().get(key));
            if (ProtobufMetadataManagerInterceptor.isErrorKeySuffix(protoKey)) continue;
            ProtobufMetadataManagerInterceptor.validateKeySuffix(protoKey);
            log.debugf("Registering proto file '%s': %s", protoKey, value);
            source.addProtoFile(protoKey, value);
        }
        ProgressCallback callback = new ProgressCallback();
        source.withProgressCallback((FileDescriptorSource.ProgressCallback)callback);
        this.registerFileDescriptorSource(source, source.getFiles().keySet().toString());
        List<KeyValuePair<String, String>> errorUpdates = this.computeErrorUpdates(callback);
        return this.updateSchemaErrorsIterator(ctx, ProtobufMetadataManagerInterceptor.copyFlags((FlagAffectedCommand)cmd), errorUpdates.iterator());
    }

    private void registerFileDescriptorSource(FileDescriptorSource source, String fileNameString) {
        try {
            this.serializationContext.registerProtoFiles(source);
            this.serializationContextRegistry.addProtoFile(SerializationContextRegistry.MarshallerType.USER, source);
        }
        catch (DescriptorParserException e) {
            throw log.failedToParseProtoFile(fileNameString, e);
        }
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        String key = ProtobufMetadataManagerInterceptor.validateKey(command.getKey());
        if (ProtobufMetadataManagerInterceptor.isErrorKeySuffix(key)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        InvocationStage stage = ((AsyncInterceptorChain)this.invoker.running()).invokeStage(ctx, (VisitableCommand)this.buildLockCommand(ProtobufMetadataManagerInterceptor.copyFlags((FlagAffectedCommand)command)));
        stage = stage.thenApplyMakeStage(ctx, (VisitableCommand)command, (rCtx, rCommand, __) -> {
            this.removeProtoFile(ProtobufMetadataManagerInterceptor.validateKey(rCommand.getKey()));
            List<KeyValuePair<String, String>> errorUpdates = this.computeErrorUpdatesAfterRemove(key);
            return this.updateSchemaErrorsIterator(rCtx, ProtobufMetadataManagerInterceptor.copyFlags((FlagAffectedCommand)rCommand), errorUpdates.iterator());
        });
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, stage);
    }

    private void removeProtoFile(String key) {
        if (this.serializationContext.getFileDescriptors().containsKey(key)) {
            this.serializationContext.unregisterProtoFile(key);
        }
        if (this.serializationContextRegistry.getUserCtx().getFileDescriptors().containsKey(key)) {
            this.serializationContextRegistry.removeProtoFile(SerializationContextRegistry.MarshallerType.USER, key);
        }
    }

    private List<KeyValuePair<String, String>> computeErrorUpdatesAfterRemove(String key) {
        ArrayList<KeyValuePair<String, String>> errorUpdates = new ArrayList<KeyValuePair<String, String>>();
        errorUpdates.add(KeyValuePair.of((Object)key, null));
        StringBuilder sb = new StringBuilder();
        for (FileDescriptor fd : this.serializationContext.getFileDescriptors().values()) {
            String fdName = fd.getName();
            if (fd.isResolved()) {
                errorUpdates.add((KeyValuePair<String, String>)KeyValuePair.of((Object)fdName, null));
                continue;
            }
            if (!sb.isEmpty()) {
                sb.append('\n');
            }
            sb.append(fdName);
            errorUpdates.add((KeyValuePair<String, String>)KeyValuePair.of((Object)fdName, (Object)"One of the imported files is missing or has errors"));
        }
        errorUpdates.add(KeyValuePair.of((Object)"", (Object)(!sb.isEmpty() ? sb.toString() : null)));
        return errorUpdates;
    }

    private InvocationStage updateSchemaErrorsIterator(InvocationContext ctx, long flagsBitSet, Iterator<KeyValuePair<String, String>> iterator) {
        RemoveCommand writeCommand;
        if (!iterator.hasNext()) {
            return InvocationStage.completedNullStage();
        }
        KeyValuePair<String, String> keyErrorPair = iterator.next();
        String errorsKey = (String)keyErrorPair.getKey() + ".errors";
        String errorsValue = (String)keyErrorPair.getValue();
        int segment = this.keyPartitioner.getSegment((Object)errorsKey);
        if (errorsValue == null) {
            writeCommand = this.commandsFactory.buildRemoveCommand((Object)errorsKey, null, segment, flagsBitSet);
        } else {
            PutKeyValueCommand put = this.commandsFactory.buildPutKeyValueCommand((Object)errorsKey, (Object)errorsValue, segment, DEFAULT_METADATA, flagsBitSet);
            put.setPutIfAbsent(true);
            writeCommand = put;
        }
        InvocationStage stage = ((AsyncInterceptorChain)this.invoker.running()).invokeStage(ctx, (VisitableCommand)writeCommand);
        return stage.thenApplyMakeStage(ctx, (VisitableCommand)writeCommand, (rCtx, rCommand, rv) -> this.updateSchemaErrorsIterator(rCtx, flagsBitSet, iterator));
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        String key = ProtobufMetadataManagerInterceptor.validateKey(command.getKey());
        if (ProtobufMetadataManagerInterceptor.isErrorKeySuffix(key)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        ProtobufMetadataManagerInterceptor.validateKeySuffix(key);
        InvocationStage stage = ((AsyncInterceptorChain)this.invoker.running()).invokeStage(ctx, (VisitableCommand)this.buildLockCommand(ProtobufMetadataManagerInterceptor.copyFlags((FlagAffectedCommand)command)));
        return ProtobufMetadataManagerInterceptor.makeStage((Object)this.asyncInvokeNext(ctx, (VisitableCommand)command, stage)).thenApply(ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
            assert (rCtx.isOriginLocal());
            return rCommand.isSuccessful() ? this.handleLocalProtoFileRegister(rCtx, ProtobufMetadataManagerInterceptor.validateKey(rCommand.getKey()), ProtobufMetadataManagerInterceptor.validateValue(rCommand.getNewValue()), ProtobufMetadataManagerInterceptor.copyFlags((FlagAffectedCommand)rCommand)).thenReturn(rCtx, rCommand, (Object)Boolean.TRUE) : InvocationStage.completedFalseStage();
        });
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
        for (String fileName : this.serializationContext.getFileDescriptors().keySet()) {
            this.serializationContext.unregisterProtoFile(fileName);
        }
        for (String name : this.serializationContextRegistry.getUserCtx().getFileDescriptors().keySet()) {
            this.serializationContextRegistry.removeProtoFile(SerializationContextRegistry.MarshallerType.USER, name);
        }
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) {
        if (command.hasAnyFlag(FlagBitSets.ROLLING_UPGRADE)) {
            return this.invokeNextThenApply(ctx, (VisitableCommand)command, this::handleComputeCommandResult);
        }
        return ProtobufMetadataManagerInterceptor.handleUnsupportedCommand((ReplicableCommand)command);
    }

    private Object handleComputeCommandResult(InvocationContext ctx, ComputeCommand cmd, Object rv) {
        if (cmd.isSuccessful()) {
            String key = ProtobufMetadataManagerInterceptor.validateKey(cmd.getKey());
            String value = ProtobufMetadataManagerInterceptor.validateValue(rv);
            if (ctx.isOriginLocal()) {
                return this.handleLocalProtoFileRegister(ctx, key, value, 0L);
            }
            this.registerProtoFile(key, value, EMPTY_CALLBACK);
        }
        return rv;
    }

    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) {
        return ProtobufMetadataManagerInterceptor.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) {
        return ProtobufMetadataManagerInterceptor.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) {
        return ProtobufMetadataManagerInterceptor.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) {
        return ProtobufMetadataManagerInterceptor.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) {
        return ProtobufMetadataManagerInterceptor.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) {
        return ProtobufMetadataManagerInterceptor.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) {
        return ProtobufMetadataManagerInterceptor.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) {
        return ProtobufMetadataManagerInterceptor.handleUnsupportedCommand((ReplicableCommand)command);
    }

    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) {
        return ProtobufMetadataManagerInterceptor.handleUnsupportedCommand((ReplicableCommand)command);
    }

    private static Object handleUnsupportedCommand(ReplicableCommand command) {
        throw log.cacheDoesNotSupportCommand("___protobuf_metadata", command.getClass().getName());
    }

    private InvocationStage handleLocalProtoFileRegister(InvocationContext ctx, String key, String value, long flags) {
        ProgressCallback progressCallback = new ProgressCallback();
        this.registerProtoFile(key, value, progressCallback);
        List<KeyValuePair<String, String>> errorUpdates = this.computeErrorUpdates(progressCallback);
        return this.updateSchemaErrorsIterator(ctx, flags, errorUpdates.iterator());
    }

    private LockControlCommand buildLockCommand(long flags) {
        return this.commandsFactory.buildLockControlCommand((Object)".errors", flags, null);
    }

    private static String validateKey(Object key) {
        if (key instanceof String) {
            return (String)key;
        }
        throw log.keyMustBeString(key.getClass());
    }

    private static String validateValue(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw log.valueMustBeString(value.getClass());
    }

    private static void validateKeySuffix(String key) {
        if (!key.endsWith(".proto")) {
            throw log.keyMustBeStringEndingWithProto(key);
        }
    }

    private static boolean isErrorKeySuffix(String key) {
        return key.endsWith(".errors");
    }

    private static long copyFlags(FlagAffectedCommand command) {
        return command.getFlagsBitSet() | FlagBitSets.IGNORE_RETURN_VALUES & (FlagBitSets.SKIP_CACHE_STORE ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static final class ProgressCallback
    implements FileDescriptorSource.ProgressCallback {
        private final Map<String, DescriptorParserException> fileStatus = new TreeMap<String, DescriptorParserException>();

        private ProgressCallback() {
        }

        Map<String, DescriptorParserException> getErrorFiles() {
            return this.fileStatus.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        Set<String> getSuccessFiles() {
            return this.fileStatus.entrySet().stream().filter(e -> e.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toSet());
        }

        public void handleError(String fileName, DescriptorParserException exception) {
            this.fileStatus.put(fileName, exception);
        }

        public void handleSuccess(String fileName) {
            this.fileStatus.putIfAbsent(fileName, null);
        }
    }
}

