/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.mapping.typebridge;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaObjectField;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.TypeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.TypeBinder;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.query.remote.impl.mapping.reference.GlobalReferenceHolder;
import org.infinispan.query.remote.impl.mapping.reference.IndexReferenceHolder;
import org.infinispan.query.remote.impl.mapping.reference.MessageReferenceProvider;
import org.infinispan.query.remote.impl.mapping.type.ProtobufKeyValuePair;
import org.infinispan.query.remote.impl.mapping.typebridge.ProtobufKeyValueBridge;
import org.infinispan.query.remote.impl.mapping.typebridge.ProtobufMessageBridge;

public class ProtobufMessageBinder
implements TypeBinder {
    private static final Log log = (Log)LogFactory.getLog(ProtobufMessageBinder.class, Log.class);
    private final GlobalReferenceHolder globalReferenceHolder;
    private final String rootMessageName;

    public ProtobufMessageBinder(GlobalReferenceHolder globalReferenceHolder, String rootMessageName) {
        this.globalReferenceHolder = globalReferenceHolder;
        this.rootMessageName = rootMessageName;
    }

    public void bind(TypeBindingContext context) {
        context.dependencies().useRootOnly();
        MessageReferenceProvider messageReferenceProvider = this.globalReferenceHolder.messageReferenceProvider(this.rootMessageName);
        String keyMessageName = messageReferenceProvider.keyMessageName();
        String keyPropertyName = messageReferenceProvider.keyPropertyName();
        IndexReferenceHolder indexReferenceProvider = this.createIndexReferenceProvider(context);
        Descriptor valueDescriptor = this.globalReferenceHolder.getDescriptor(this.rootMessageName);
        if (keyMessageName == null) {
            context.bridge(byte[].class, (TypeBridge)new ProtobufMessageBridge(indexReferenceProvider, valueDescriptor));
            return;
        }
        Descriptor keyDescriptor = this.globalReferenceHolder.getDescriptor(keyMessageName);
        context.bridge(ProtobufKeyValuePair.class, (TypeBridge)new ProtobufKeyValueBridge(indexReferenceProvider, keyPropertyName, keyDescriptor, valueDescriptor));
    }

    private IndexReferenceHolder createIndexReferenceProvider(TypeBindingContext context) {
        HashMap fieldReferenceMap = new HashMap();
        HashMap<String, IndexObjectFieldReference> objectReferenceMap = new HashMap<String, IndexObjectFieldReference>();
        HashMap<String, IndexReferenceHolder.GeoIndexFieldReference> geoReferenceMap = new HashMap<String, IndexReferenceHolder.GeoIndexFieldReference>();
        Stack<State> stack = new Stack<State>();
        stack.push(new State(this.globalReferenceHolder.getMessageReferenceProviders().get(this.rootMessageName), "", context.indexSchemaElement(), 0));
        Integer maxDepth = null;
        while (!stack.isEmpty()) {
            State currentState = (State)stack.pop();
            fieldReferenceMap.putAll(currentState.bind());
            geoReferenceMap.putAll(currentState.bindGeo());
            if (maxDepth != null && currentState.depth == maxDepth) continue;
            for (MessageReferenceProvider.Embedded embedded : currentState.messageReferenceProvider.getEmbedded()) {
                String newPath = "".equals(currentState.path) ? embedded.getFieldName() : currentState.path + "." + embedded.getFieldName();
                maxDepth = embedded.getIncludeDepth();
                MessageReferenceProvider messageReferenceProvider = this.globalReferenceHolder.messageProviderForEmbeddedType(embedded);
                ObjectStructure structure = embedded.getStructure();
                if (structure == null) {
                    structure = ObjectStructure.FLATTENED;
                }
                IndexSchemaObjectField indexSchemaElement = currentState.indexSchemaElement.objectField(embedded.getFieldName(), structure);
                if (embedded.isRepeated()) {
                    indexSchemaElement.multiValued();
                }
                objectReferenceMap.put(newPath, (IndexObjectFieldReference)indexSchemaElement.toReference());
                State state = new State(messageReferenceProvider, newPath, (IndexSchemaElement)indexSchemaElement, currentState.depth + 1);
                stack.push(state);
            }
        }
        return new IndexReferenceHolder(fieldReferenceMap, objectReferenceMap, geoReferenceMap);
    }

    private static class State {
        private final MessageReferenceProvider messageReferenceProvider;
        private final String path;
        private final IndexSchemaElement indexSchemaElement;
        private final int depth;

        public State(MessageReferenceProvider messageReferenceProvider, String path, IndexSchemaElement indexSchemaElement, int depth) {
            this.messageReferenceProvider = messageReferenceProvider;
            this.path = path;
            this.indexSchemaElement = indexSchemaElement;
            this.depth = depth;
        }

        public Map<String, IndexFieldReference<?>> bind() {
            return this.messageReferenceProvider.bind(this.indexSchemaElement, this.path);
        }

        public Map<String, IndexReferenceHolder.GeoIndexFieldReference> bindGeo() {
            return this.messageReferenceProvider.bindGeo(this.indexSchemaElement, this.path);
        }
    }
}

