/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote;

import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.util.Map;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.CustomInterceptorsConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.interceptors.BatchingInterceptor;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.InvocationContextInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.lifecycle.AbstractModuleLifecycle;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.ExternalizerIds;
import org.infinispan.query.remote.SerializationContextHolder;
import org.infinispan.query.remote.client.MarshallerRegistration;
import org.infinispan.query.remote.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.indexing.RemoteValueWrapperInterceptor;
import org.infinispan.query.remote.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LifecycleManager
extends AbstractModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleManager.class, Log.class);
    private boolean isSerializationContextInitialized = false;

    private void initSerializationContext() {
        if (!this.isSerializationContextInitialized) {
            this.isSerializationContextInitialized = true;
            try {
                SerializationContext serCtx = SerializationContextHolder.getSerializationContext();
                MarshallerRegistration.registerMarshallers((SerializationContext)serCtx);
            }
            catch (IOException e) {
                throw new CacheException("Failed to initialise serialization context", (Throwable)e);
            }
            catch (Descriptors.DescriptorValidationException e) {
                throw new CacheException("Failed to initialise serialization context", (Throwable)e);
            }
        }
    }

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        this.initSerializationContext();
        Map externalizerMap = globalCfg.serialization().advancedExternalizers();
        externalizerMap.put(ExternalizerIds.PROTOBUF_VALUE_WRAPPER, new ProtobufValueWrapper.Externalizer());
    }

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        if (cfg.indexing().enabled()) {
            log.infof("Registering RemoteValueWrapperInterceptor for cache %s", cacheName);
            this.createRemoteIndexingInterceptor(cr, cfg);
        }
    }

    private void createRemoteIndexingInterceptor(ComponentRegistry cr, Configuration cfg) {
        RemoteValueWrapperInterceptor wrapperInterceptor = (RemoteValueWrapperInterceptor)((Object)cr.getComponent(RemoteValueWrapperInterceptor.class));
        if (wrapperInterceptor == null) {
            wrapperInterceptor = new RemoteValueWrapperInterceptor();
            InterceptorChain ic = (InterceptorChain)cr.getComponent(InterceptorChain.class);
            ConfigurationBuilder builder = new ConfigurationBuilder().read(cfg);
            InterceptorConfigurationBuilder interceptorBuilder = builder.customInterceptors().addInterceptor();
            interceptorBuilder.interceptor((CommandInterceptor)wrapperInterceptor);
            if (cfg.invocationBatching().enabled()) {
                if (ic != null) {
                    ic.addInterceptorAfter((CommandInterceptor)wrapperInterceptor, BatchingInterceptor.class);
                }
                interceptorBuilder.after(BatchingInterceptor.class);
            } else {
                if (ic != null) {
                    ic.addInterceptorAfter((CommandInterceptor)wrapperInterceptor, InvocationContextInterceptor.class);
                }
                interceptorBuilder.after(InvocationContextInterceptor.class);
            }
            if (ic != null) {
                cr.registerComponent((Object)wrapperInterceptor, RemoteValueWrapperInterceptor.class);
                cr.registerComponent((Object)wrapperInterceptor, ((Object)((Object)wrapperInterceptor)).getClass().getName(), true);
            }
            cfg.customInterceptors().interceptors(builder.build().customInterceptors().interceptors());
        }
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
        Configuration configuration = (Configuration)cr.getComponent(Configuration.class);
        boolean indexingEnabled = configuration.indexing().enabled();
        if (!indexingEnabled) {
            if (this.verifyChainContainsRemoteIndexingInterceptor(cr)) {
                throw new IllegalStateException("It was NOT expected to find the RemoteValueWrapperInterceptor registered in the InterceptorChain as indexing was disabled, but it was found");
            }
            return;
        }
        if (!this.verifyChainContainsRemoteIndexingInterceptor(cr)) {
            throw new IllegalStateException("It was expected to find the RemoteValueWrapperInterceptor registered in the InterceptorChain but it wasn't found");
        }
    }

    private boolean verifyChainContainsRemoteIndexingInterceptor(ComponentRegistry cr) {
        InterceptorChain interceptorChain = (InterceptorChain)cr.getComponent(InterceptorChain.class);
        return interceptorChain.containsInterceptorType(RemoteValueWrapperInterceptor.class, true);
    }

    public void cacheStopped(ComponentRegistry cr, String cacheName) {
        Configuration cfg = (Configuration)cr.getComponent(Configuration.class);
        this.removeRemoteIndexingInterceptorFromConfig(cfg);
    }

    private void removeRemoteIndexingInterceptorFromConfig(Configuration cfg) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        CustomInterceptorsConfigurationBuilder customInterceptorsBuilder = builder.customInterceptors();
        for (InterceptorConfiguration interceptorConfig : cfg.customInterceptors().interceptors()) {
            if (interceptorConfig.interceptor() instanceof RemoteValueWrapperInterceptor) continue;
            customInterceptorsBuilder.addInterceptor().read(interceptorConfig);
        }
        cfg.customInterceptors().interceptors(builder.build().customInterceptors().interceptors());
    }
}

