/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.indexing;

import com.google.protobuf.Descriptors;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MessageContext {
    private final String fieldName;
    private final Descriptors.Descriptor messageDescriptor;
    private final Map<String, Descriptors.FieldDescriptor> fieldDescriptors;
    private final Set<Integer> readFields;
    private final MessageContext parentContext;

    MessageContext(Descriptors.Descriptor messageDescriptor) {
        this(null, null, messageDescriptor);
    }

    MessageContext(String fieldName, MessageContext parentContext, Descriptors.Descriptor messageDescriptor) {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("messageDescriptor cannot be null");
        }
        this.fieldName = fieldName;
        this.parentContext = parentContext;
        this.messageDescriptor = messageDescriptor;
        List fields = messageDescriptor.getFields();
        this.fieldDescriptors = new HashMap<String, Descriptors.FieldDescriptor>(fields.size());
        for (Descriptors.FieldDescriptor fd : fields) {
            this.fieldDescriptors.put(fd.getName(), fd);
        }
        this.readFields = new HashSet<Integer>(this.fieldDescriptors.size());
    }

    String getFieldName() {
        return this.fieldName;
    }

    Descriptors.Descriptor getMessageDescriptor() {
        return this.messageDescriptor;
    }

    MessageContext getParentContext() {
        return this.parentContext;
    }

    Set<Integer> getReadFields() {
        return this.readFields;
    }

    Descriptors.FieldDescriptor getFieldByName(String fieldName) {
        Descriptors.FieldDescriptor fd = this.fieldDescriptors.get(fieldName);
        if (fd == null) {
            throw new IllegalArgumentException("Unknown field : " + fieldName);
        }
        return fd;
    }
}

