/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote;

import com.google.protobuf.Descriptors;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.transaction.TransactionMode;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="ProtobufMetadataManager", description="Component that acts as a manager and container for Protocol Buffers metadata descriptors in the scope of a CacheManger.")
public class ProtobufMetadataManager {
    public static final String OBJECT_NAME = "ProtobufMetadataManager";
    private static final String METADATA_CACHE_NAME = "__ProtobufMetadataManager__";
    private ObjectName objectName;
    private final EmbeddedCacheManager cacheManager;
    private Cache<String, byte[]> metadataCache;
    private final SerializationContext serCtx = ProtobufUtil.newSerializationContext();

    public ProtobufMetadataManager(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<String, byte[]> getMetadataCache() {
        if (this.metadataCache == null) {
            ProtobufMetadataManager protobufMetadataManager = this;
            synchronized (protobufMetadataManager) {
                if (this.metadataCache == null) {
                    this.cacheManager.defineConfiguration(METADATA_CACHE_NAME, this.getMetadataCacheConfig());
                    this.metadataCache = this.cacheManager.getCache(METADATA_CACHE_NAME);
                    this.metadataCache.addListener((Object)new MetadataCacheListener());
                }
            }
        }
        return this.metadataCache;
    }

    private Configuration getMetadataCacheConfig() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        boolean isClustered = this.cacheManager.getGlobalComponentRegistry().getGlobalConfiguration().isClustered();
        configurationBuilder.clustering().cacheMode(isClustered ? CacheMode.REPL_SYNC : CacheMode.LOCAL);
        configurationBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        configurationBuilder.clustering().stateTransfer().fetchInMemoryState(true);
        return configurationBuilder.build();
    }

    @ManagedOperation(description="Registers a Protobuf definition file", displayName="Register Protofile")
    public void registerProtofile(byte[] descriptorFile) throws IOException, Descriptors.DescriptorValidationException {
        this.getMetadataCache().put((Object)UUID.randomUUID().toString(), (Object)descriptorFile);
    }

    public void registerProtofile(InputStream descriptorFile) throws IOException, Descriptors.DescriptorValidationException {
        this.registerProtofile(this.readStream(descriptorFile));
    }

    public void registerProtofile(String classpathResource) throws IOException, Descriptors.DescriptorValidationException {
        InputStream is = this.getClass().getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Missing resource: " + classpathResource);
        }
        this.registerProtofile(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readStream(InputStream is) throws IOException {
        try {
            int len;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            is.close();
        }
    }

    public SerializationContext getSerializationContext() {
        return this.serCtx;
    }

    public static SerializationContext getSerializationContext(EmbeddedCacheManager cacheManager) {
        if (cacheManager == null) {
            throw new IllegalArgumentException("cacheManager cannot be null");
        }
        ProtobufMetadataManager metadataManager = (ProtobufMetadataManager)cacheManager.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        if (metadataManager == null) {
            throw new IllegalStateException("ProtobufMetadataManager not initialised yet!");
        }
        return metadataManager.getSerializationContext();
    }

    @Listener
    public class MetadataCacheListener {
        @CacheEntryCreated
        public void created(CacheEntryCreatedEvent<String, byte[]> e) throws IOException, Descriptors.DescriptorValidationException {
            if (!e.isPre()) {
                this.registerProtofile((byte[])e.getValue());
            }
        }

        @CacheEntryModified
        public void modified(CacheEntryModifiedEvent<String, byte[]> e) throws IOException, Descriptors.DescriptorValidationException {
            if (!e.isPre()) {
                this.registerProtofile((byte[])e.getValue());
            }
        }

        private void registerProtofile(byte[] descriptorFile) throws IOException, Descriptors.DescriptorValidationException {
            ProtobufMetadataManager.this.getSerializationContext().registerProtofile((InputStream)new ByteArrayInputStream(descriptorFile));
        }
    }
}

