/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.search;

import java.util.regex.Pattern;
import org.apache.lucene.search.Query;
import org.hibernate.hql.ast.spi.predicate.LikePredicate;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;

class IspnLuceneLikePredicate
extends LikePredicate<Query> {
    private static final String LUCENE_SINGLE_CHARACTER_WILDCARD = "?";
    private static final String LUCENE_MULTIPLE_CHARACTERS_WILDCARD = "*";
    private static final Pattern MULTIPLE_CHARACTERS_WILDCARD_PATTERN = Pattern.compile("%");
    private static final Pattern SINGLE_CHARACTER_WILDCARD_PATTERN = Pattern.compile("_");
    private final QueryBuilder builder;

    public IspnLuceneLikePredicate(QueryBuilder builder, String propertyName, String patternValue) {
        super(propertyName, patternValue, null);
        this.builder = builder;
    }

    public Query getQuery() {
        String patternValue = MULTIPLE_CHARACTERS_WILDCARD_PATTERN.matcher(this.patternValue).replaceAll(LUCENE_MULTIPLE_CHARACTERS_WILDCARD);
        patternValue = SINGLE_CHARACTER_WILDCARD_PATTERN.matcher(patternValue).replaceAll(LUCENE_SINGLE_CHARACTER_WILDCARD);
        return ((TermMatchingContext)this.builder.keyword().wildcard().onField(this.propertyName).ignoreFieldBridge()).matching((Object)patternValue).createQuery();
    }
}

