/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.indexing;

import com.google.protobuf.Descriptors;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.infinispan.protostream.TagHandler;
import org.infinispan.query.remote.indexing.ReadMessageContext;

class IndexingTagHandler
implements TagHandler {
    public static final int INDEXED_MESSAGE_OPTION = 55554;
    public static final int INDEXED_FIELD_OPTION = 55555;
    public static final Integer TRUE_INT = 1;
    public static final Integer FALSE_INT = 0;
    private static final LuceneOptions NOT_STORED_NOT_ANALYZED = new LuceneOptionsImpl(new DocumentFieldMetadata.Builder(null, Store.NO, Field.Index.NOT_ANALYZED, Field.TermVector.NO).boost(Float.valueOf(1.0f)).build());
    private static final LuceneOptions STORED_NOT_ANALYZED = new LuceneOptionsImpl(new DocumentFieldMetadata.Builder(null, Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO).boost(Float.valueOf(1.0f)).build());
    private final Document document;
    private ReadMessageContext messageContext;

    public IndexingTagHandler(Descriptors.Descriptor messageDescriptor, Document document) {
        this.document = document;
        this.messageContext = new ReadMessageContext(null, null, messageDescriptor);
    }

    public void onStart() {
        NOT_STORED_NOT_ANALYZED.addFieldToDocument("$type$", this.messageContext.getMessageDescriptor().getFullName(), this.document);
    }

    public void onTag(int fieldNumber, String fieldName, Descriptors.FieldDescriptor.Type type, Descriptors.FieldDescriptor.JavaType javaType, Object tagValue) {
        this.messageContext.getSeenFields().add(fieldNumber);
        if (fieldName != null && this.isIndexed(fieldNumber)) {
            this.addFieldToDocument(fieldName, type, tagValue);
        }
    }

    private void addFieldToDocument(String fieldName, Descriptors.FieldDescriptor.Type type, Object value) {
        LuceneOptions luceneOptions = STORED_NOT_ANALYZED;
        if (value == null) {
            value = "_null_";
            luceneOptions = NOT_STORED_NOT_ANALYZED;
        }
        String fn = this.getFullFieldName(fieldName);
        switch (type) {
            case DOUBLE: 
            case FLOAT: 
            case INT64: 
            case UINT64: 
            case INT32: 
            case FIXED64: 
            case FIXED32: 
            case UINT32: 
            case SFIXED32: 
            case SFIXED64: 
            case SINT32: 
            case SINT64: 
            case ENUM: {
                luceneOptions.addNumericFieldToDocument(fn, value, this.document);
                break;
            }
            case BOOL: {
                luceneOptions.addNumericFieldToDocument(fn, (Object)((Boolean)value != false ? TRUE_INT : FALSE_INT), this.document);
                break;
            }
            default: {
                luceneOptions.addFieldToDocument(fn, String.valueOf(value), this.document);
            }
        }
    }

    private String getFullFieldName(String fieldName) {
        String fieldPrefix = this.messageContext.getFullFieldName();
        return fieldPrefix != null ? fieldPrefix + "." + fieldName : fieldName;
    }

    private boolean isIndexed(int fieldNumber) {
        return true;
    }

    public void onStartNested(int fieldNumber, String fieldName, Descriptors.Descriptor messageDescriptor) {
        this.messageContext.getSeenFields().add(fieldNumber);
        this.pushContext(fieldName, messageDescriptor);
    }

    public void onEndNested(int fieldNumber, String fieldName, Descriptors.Descriptor messageDescriptor) {
        this.popContext();
    }

    public void onEnd() {
        this.indexMissingFields();
    }

    private void pushContext(String fieldName, Descriptors.Descriptor messageDescriptor) {
        this.messageContext = new ReadMessageContext(this.messageContext, fieldName, messageDescriptor);
    }

    private void popContext() {
        this.indexMissingFields();
        this.messageContext = (ReadMessageContext)this.messageContext.getParentContext();
    }

    private void indexMissingFields() {
        for (Descriptors.FieldDescriptor fd : this.messageContext.getMessageDescriptor().getFields()) {
            if (this.messageContext.getSeenFields().contains(fd.getNumber())) continue;
            Object defaultValue = fd.getType() == Descriptors.FieldDescriptor.Type.MESSAGE || fd.getType() == Descriptors.FieldDescriptor.Type.GROUP || fd.toProto().getDefaultValue().isEmpty() ? null : fd.getDefaultValue();
            this.addFieldToDocument(fd.getName(), fd.getType(), defaultValue);
        }
    }
}

