/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote;

import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.lucene.LuceneProcessingChain;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.hql.lucene.spi.FieldBridgeProvider;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.impl.BridgeFactory;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;
import org.infinispan.query.remote.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.search.NullEncodingDoubleNumericFieldBridge;
import org.infinispan.query.remote.search.NullEncodingFloatNumericFieldBridge;
import org.infinispan.query.remote.search.NullEncodingIntegerNumericFieldBridge;
import org.infinispan.query.remote.search.NullEncodingLongNumericFieldBridge;
import org.infinispan.server.core.QueryFacade;

public class QueryFacadeImpl
implements QueryFacade {
    public static final String TYPE_FIELD_NAME = "$type$";
    public static final String NULL_TOKEN = "_null_";

    public byte[] query(AdvancedCache<byte[], byte[]> cache, byte[] query) {
        if (!cache.getCacheConfiguration().indexing().enabled()) {
            throw new CacheException("Indexing is not enabled for cache " + cache.getName());
        }
        try {
            return this.executeQuery(cache, query);
        }
        catch (IOException e) {
            throw new CacheException("An exception has occurred during query execution", (Throwable)e);
        }
    }

    private byte[] executeQuery(AdvancedCache<byte[], byte[]> cache, byte[] query) throws IOException {
        Query luceneQuery;
        List projections;
        Class targetEntity;
        Descriptors.Descriptor messageDescriptor;
        LuceneQueryParsingResult parsingResult;
        LuceneProcessingChain processingChain;
        final SerializationContext serCtx = ProtobufMetadataManager.getSerializationContext(cache.getCacheManager());
        QueryRequest request = (QueryRequest)ProtobufUtil.fromByteArray((SerializationContext)serCtx, (byte[])query, (int)0, (int)query.length, QueryRequest.class);
        SearchManager searchManager = Search.getSearchManager(cache);
        QueryParser queryParser = new QueryParser();
        SearchFactoryIntegrator searchFactory = (SearchFactoryIntegrator)searchManager.getSearchFactory();
        if (cache.getCacheConfiguration().compatibility().enabled()) {
            final QueryInterceptor queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
            EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

                public Class<?> getClassFromName(String entityName) {
                    MessageMarshaller messageMarshaller = (MessageMarshaller)serCtx.getMarshaller(entityName);
                    Class clazz = messageMarshaller.getJavaClass();
                    Boolean isIndexed = (Boolean)queryInterceptor.getKnownClasses().get(clazz);
                    return isIndexed != null && isIndexed != false ? clazz : null;
                }
            };
            processingChain = new LuceneProcessingChain.Builder(searchFactory, entityNamesResolver).buildProcessingChainForClassBasedEntities();
            parsingResult = (LuceneQueryParsingResult)queryParser.parseQuery(request.getJpqlString(), (AstProcessingChain)processingChain);
            MessageMarshaller messageMarshaller = (MessageMarshaller)serCtx.getMarshaller(parsingResult.getTargetEntity());
            messageDescriptor = serCtx.getMessageDescriptor(messageMarshaller.getTypeName());
            targetEntity = parsingResult.getTargetEntity();
            projections = parsingResult.getProjections();
            luceneQuery = parsingResult.getQuery();
        } else {
            EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

                public Class<?> getClassFromName(String entityName) {
                    return serCtx.canMarshall(entityName) ? ProtobufValueWrapper.class : null;
                }
            };
            FieldBridgeProvider fieldBridgeProvider = new FieldBridgeProvider(){

                public FieldBridge getFieldBridge(String type, String propertyPath) {
                    Descriptors.Descriptor md = serCtx.getMessageDescriptor(type);
                    Descriptors.FieldDescriptor fd = QueryFacadeImpl.this.getFieldDescriptor(md, propertyPath);
                    switch (fd.getType()) {
                        case DOUBLE: {
                            return new NullEncodingDoubleNumericFieldBridge(QueryFacadeImpl.NULL_TOKEN);
                        }
                        case FLOAT: {
                            return new NullEncodingFloatNumericFieldBridge(QueryFacadeImpl.NULL_TOKEN);
                        }
                        case INT64: 
                        case UINT64: 
                        case FIXED64: 
                        case SFIXED64: 
                        case SINT64: {
                            return new NullEncodingLongNumericFieldBridge(QueryFacadeImpl.NULL_TOKEN);
                        }
                        case INT32: 
                        case FIXED32: 
                        case UINT32: 
                        case SFIXED32: 
                        case SINT32: 
                        case BOOL: 
                        case ENUM: {
                            return new NullEncodingIntegerNumericFieldBridge(QueryFacadeImpl.NULL_TOKEN);
                        }
                        case STRING: 
                        case BYTES: 
                        case GROUP: 
                        case MESSAGE: {
                            return new NullEncodingTwoWayFieldBridge(BridgeFactory.STRING, QueryFacadeImpl.NULL_TOKEN);
                        }
                    }
                    return null;
                }
            };
            processingChain = new LuceneProcessingChain.Builder(searchFactory, entityNamesResolver).buildProcessingChainForDynamicEntities(fieldBridgeProvider);
            parsingResult = (LuceneQueryParsingResult)queryParser.parseQuery(request.getJpqlString(), (AstProcessingChain)processingChain);
            targetEntity = parsingResult.getTargetEntity();
            messageDescriptor = serCtx.getMessageDescriptor(parsingResult.getTargetEntityName());
            projections = parsingResult.getProjections();
            QueryBuilder qb = searchManager.getSearchFactory().buildQueryBuilder().forEntity(targetEntity).get();
            luceneQuery = qb.bool().must(((TermMatchingContext)((TermMatchingContext)qb.keyword().onField(TYPE_FIELD_NAME).ignoreFieldBridge()).ignoreAnalyzer()).matching((Object)messageDescriptor.getFullName()).createQuery()).must(parsingResult.getQuery()).createQuery();
        }
        CacheQuery cacheQuery = searchManager.getQuery(luceneQuery, new Class[]{targetEntity});
        if (request.getSortCriteria() != null && !request.getSortCriteria().isEmpty()) {
            SortField[] sortField = new SortField[request.getSortCriteria().size()];
            int i = 0;
            for (QueryRequest.SortCriteria sc : request.getSortCriteria()) {
                Descriptors.FieldDescriptor field = this.getFieldDescriptor(messageDescriptor, sc.getAttributePath());
                int sortType = 3;
                if (field != null) {
                    switch (field.getJavaType()) {
                        case INT: 
                        case BOOLEAN: 
                        case ENUM: {
                            sortType = 4;
                            break;
                        }
                        case LONG: {
                            sortType = 6;
                            break;
                        }
                        case FLOAT: {
                            sortType = 5;
                            break;
                        }
                        case DOUBLE: {
                            sortType = 7;
                        }
                    }
                }
                sortField[i++] = new SortField(sc.getAttributePath(), sortType, !sc.isAscending());
            }
            cacheQuery = cacheQuery.sort(new Sort(sortField));
        }
        int projSize = 0;
        if (projections != null && !projections.isEmpty()) {
            projSize = projections.size();
            cacheQuery = cacheQuery.projection(projections.toArray(new String[projSize]));
        }
        if (request.getStartOffset() > 0L) {
            cacheQuery = cacheQuery.firstResult((int)request.getStartOffset());
        }
        if (request.getMaxResults() > 0) {
            cacheQuery = cacheQuery.maxResults(request.getMaxResults());
        }
        List list = cacheQuery.list();
        ArrayList<WrappedMessage> results = new ArrayList<WrappedMessage>(projSize == 0 ? list.size() : list.size() * projSize);
        for (Object o : list) {
            if (projSize == 0) {
                results.add(new WrappedMessage(o));
                continue;
            }
            Object[] row = (Object[])o;
            for (int j = 0; j < projSize; ++j) {
                results.add(new WrappedMessage(row[j]));
            }
        }
        QueryResponse response = new QueryResponse();
        response.setNumResults(list.size());
        response.setProjectionSize(projSize);
        response.setResults(results);
        return ProtobufUtil.toByteArray((SerializationContext)serCtx, (Object)response);
    }

    private Descriptors.FieldDescriptor getFieldDescriptor(Descriptors.Descriptor messageDescriptor, String attributePath) {
        Descriptors.FieldDescriptor fd = null;
        String[] split = attributePath.split("[.]");
        for (int i = 0; i < split.length; ++i) {
            String name = split[i];
            fd = messageDescriptor.findFieldByName(name);
            if (fd == null) {
                throw new IllegalArgumentException("Unknown field " + name + " in type " + messageDescriptor.getFullName());
            }
            if (i >= split.length - 1) continue;
            messageDescriptor = fd.getMessageType();
        }
        return fd;
    }
}

