/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote;

import com.google.protobuf.Descriptors;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.management.ObjectName;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.logging.Log;
import org.infinispan.registry.ClusterRegistry;
import org.infinispan.registry.ScopedKey;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="ProtobufMetadataManager", description="Component that acts as a manager and container for Protocol Buffers metadata descriptors in the scope of a CacheManger.")
public class ProtobufMetadataManager {
    private static final Log log = (Log)LogFactory.getLog(ProtobufMetadataManager.class, Log.class);
    public static final String OBJECT_NAME = "ProtobufMetadataManager";
    private static final String REGISTRY_SCOPE = ProtobufMetadataManager.class.getName();
    private ObjectName objectName;
    private ClusterRegistry<String, String, byte[]> clusterRegistry;
    private volatile ProtobufMetadataRegistryListener registryListener;
    private final SerializationContext serCtx;

    public ProtobufMetadataManager(SerializationContext serCtx) {
        this.serCtx = serCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInit() {
        if (this.registryListener == null) {
            ProtobufMetadataManager protobufMetadataManager = this;
            synchronized (protobufMetadataManager) {
                if (this.registryListener == null) {
                    this.registryListener = new ProtobufMetadataRegistryListener();
                    this.clusterRegistry.addListener((Object)REGISTRY_SCOPE, (Object)this.registryListener);
                    for (String uuid : this.clusterRegistry.keys((Object)REGISTRY_SCOPE)) {
                        byte[] descriptorFile = (byte[])this.clusterRegistry.get((Object)REGISTRY_SCOPE, (Object)uuid);
                        try {
                            this.serCtx.registerProtofile((InputStream)new ByteArrayInputStream(descriptorFile));
                        }
                        catch (Exception e) {
                            log.error(e);
                        }
                    }
                }
            }
        }
    }

    @Inject
    protected void injectDependencies(ClusterRegistry<String, String, byte[]> clusterRegistry) {
        this.clusterRegistry = clusterRegistry;
    }

    @Stop
    protected void stop() {
        if (this.registryListener != null) {
            this.clusterRegistry.removeListener((Object)this.registryListener);
            this.registryListener = null;
        }
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public <T> void registerMarshaller(Class<? extends T> clazz, BaseMarshaller<T> marshaller) {
        this.ensureInit();
        this.serCtx.registerMarshaller(clazz, marshaller);
    }

    @ManagedOperation(description="Registers a Protobuf definition file", displayName="Register Protofile")
    public void registerProtofile(byte[] descriptorFile) {
        this.ensureInit();
        this.clusterRegistry.put((Object)REGISTRY_SCOPE, (Object)UUID.randomUUID().toString(), (Object)descriptorFile);
    }

    public void registerProtofile(InputStream descriptorFile) throws IOException, Descriptors.DescriptorValidationException {
        this.registerProtofile(Util.readStream((InputStream)descriptorFile));
    }

    public void registerProtofile(String classpathResource) throws IOException, Descriptors.DescriptorValidationException {
        InputStream is = this.getClass().getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Missing resource: " + classpathResource);
        }
        this.registerProtofile(is);
    }

    public static SerializationContext getSerializationContext(EmbeddedCacheManager cacheManager) {
        if (cacheManager == null) {
            throw new IllegalArgumentException("cacheManager cannot be null");
        }
        ProtobufMetadataManager metadataManager = (ProtobufMetadataManager)cacheManager.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        if (metadataManager == null) {
            throw new IllegalStateException("ProtobufMetadataManager not initialised yet!");
        }
        metadataManager.ensureInit();
        return metadataManager.serCtx;
    }

    @Listener
    class ProtobufMetadataRegistryListener {
        ProtobufMetadataRegistryListener() {
        }

        @CacheEntryCreated
        public void created(CacheEntryCreatedEvent<ScopedKey<String, String>, byte[]> e) throws IOException, Descriptors.DescriptorValidationException {
            if (!e.isPre()) {
                this.registerProtofile((byte[])e.getValue());
            }
        }

        @CacheEntryModified
        public void modified(CacheEntryModifiedEvent<ScopedKey<String, String>, byte[]> e) throws IOException, Descriptors.DescriptorValidationException {
            if (!e.isPre()) {
                this.registerProtofile((byte[])e.getValue());
            }
        }

        private void registerProtofile(byte[] descriptorFile) throws IOException, Descriptors.DescriptorValidationException {
            ProtobufMetadataManager.this.serCtx.registerProtofile((InputStream)new ByteArrayInputStream(descriptorFile));
        }
    }
}

