/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.Configuration;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.query.remote.ProtobufMetadataManager;

final class DelegatingSerializationContext
implements SerializationContext {
    private final ProtobufMetadataManager protobufMetadataManager;
    private final SerializationContext delegate;

    public DelegatingSerializationContext(ProtobufMetadataManager protobufMetadataManager) {
        this.protobufMetadataManager = protobufMetadataManager;
        this.delegate = protobufMetadataManager.getSerializationContext();
    }

    public SerializationContext getDelegate() {
        return this.delegate;
    }

    public Configuration getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public void registerProtoFiles(FileDescriptorSource source) throws IOException, DescriptorParserException {
        Map fileDescriptors = source.getFileDescriptors();
        HashMap<String, String> files = new HashMap<String, String>(fileDescriptors.size());
        for (String key : fileDescriptors.keySet()) {
            files.put(key, new String((char[])fileDescriptors.get(key)));
        }
        this.protobufMetadataManager.getCache().putAll(files);
    }

    public void registerProtoFiles(String ... classpathResources) throws IOException, DescriptorParserException {
        FileDescriptorSource fileDescriptorSource = new FileDescriptorSource();
        fileDescriptorSource.addProtoFiles(classpathResources);
        this.registerProtoFiles(fileDescriptorSource);
    }

    public void unregisterProtoFile(String name) {
        this.protobufMetadataManager.getCache().remove((Object)name);
    }

    public Map<String, FileDescriptor> getFileDescriptors() {
        return this.delegate.getFileDescriptors();
    }

    public <T> void registerMarshaller(BaseMarshaller<T> marshaller) {
        this.delegate.registerMarshaller(marshaller);
    }

    public Descriptor getMessageDescriptor(String fullName) {
        return this.delegate.getMessageDescriptor(fullName);
    }

    public EnumDescriptor getEnumDescriptor(String fullName) {
        return this.delegate.getEnumDescriptor(fullName);
    }

    public boolean canMarshall(Class clazz) {
        return this.delegate.canMarshall(clazz);
    }

    public boolean canMarshall(String descriptorFullName) {
        return this.delegate.canMarshall(descriptorFullName);
    }

    public <T> BaseMarshaller<T> getMarshaller(String descriptorFullName) {
        return this.delegate.getMarshaller(descriptorFullName);
    }

    public <T> BaseMarshaller<T> getMarshaller(Class<T> clazz) {
        return this.delegate.getMarshaller(clazz);
    }
}

