/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.management.MBeanException;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.PessimisticLockingInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.CompatibilityProtoStreamMarshaller;
import org.infinispan.query.remote.DelegatingSerializationContext;
import org.infinispan.query.remote.ProtobufMetadataManagerInterceptor;
import org.infinispan.query.remote.ProtobufMetadataManagerMBean;
import org.infinispan.query.remote.client.MarshallerRegistration;
import org.infinispan.query.remote.logging.Log;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="ProtobufMetadataManager", description="Component that acts as a manager and container for Protocol Buffers metadata descriptors in the scope of a CacheManger.")
public class ProtobufMetadataManager
implements ProtobufMetadataManagerMBean {
    private static final Log log = (Log)LogFactory.getLog(ProtobufMetadataManager.class, Log.class);
    public static final String OBJECT_NAME = "ProtobufMetadataManager";
    public static final String PROTOBUF_METADATA_CACHE_NAME = "___protobuf_metadata";
    private Cache<String, String> protobufSchemaCache;
    private ObjectName objectName;
    private final SerializationContext serCtx = ProtobufUtil.newSerializationContext((org.infinispan.protostream.Configuration)new org.infinispan.protostream.ConfigurationBuilder().build());
    private EmbeddedCacheManager cacheManager;

    public ProtobufMetadataManager() {
        try {
            MarshallerRegistration.registerMarshallers((SerializationContext)this.serCtx);
        }
        catch (IOException | DescriptorParserException e) {
            throw new CacheException("Failed to initialise serialization context", e);
        }
    }

    @Inject
    public void init(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        Configuration cacheConfiguration = cacheManager.getCacheConfiguration(PROTOBUF_METADATA_CACHE_NAME);
        if (cacheConfiguration != null) {
            throw new IllegalStateException("A cache configuration named ___protobuf_metadata already exists. This must not be configured externally by the user.");
        }
        cacheManager.defineConfiguration(PROTOBUF_METADATA_CACHE_NAME, this.getProtobufMetadataCacheConfig().build());
    }

    Cache<String, String> getCache() {
        if (this.protobufSchemaCache == null) {
            this.protobufSchemaCache = this.cacheManager.getCache(PROTOBUF_METADATA_CACHE_NAME);
        }
        return this.protobufSchemaCache;
    }

    private ConfigurationBuilder getProtobufMetadataCacheConfig() {
        GlobalConfiguration globalConfiguration = this.cacheManager.getGlobalComponentRegistry().getGlobalConfiguration();
        CacheMode cacheMode = globalConfiguration.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL;
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).invocationBatching().enable().transaction().lockingMode(LockingMode.PESSIMISTIC).syncCommitPhase(true).syncRollbackPhase(true).locking().isolationLevel(IsolationLevel.READ_COMMITTED).useLockStriping(false).clustering().cacheMode(cacheMode).sync().stateTransfer().fetchInMemoryState(true).compatibility().enable().marshaller((Marshaller)new CompatibilityProtoStreamMarshaller()).customInterceptors().addInterceptor().interceptor((CommandInterceptor)new ProtobufMetadataManagerInterceptor()).after(PessimisticLockingInterceptor.class);
        return cfg;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public void registerMarshaller(BaseMarshaller<?> marshaller) {
        this.serCtx.registerMarshaller(marshaller);
    }

    @Override
    @ManagedOperation(description="Registers a set of Protobuf definition files", displayName="Register Protofiles")
    public void registerProtofiles(@Parameter(name="fileNames", description="names of the protofiles") String[] names, @Parameter(name="fileContents", description="content of the files") String[] contents) throws Exception {
        if (names.length != contents.length) {
            throw new MBeanException(new IllegalArgumentException("invalid parameter sizes"));
        }
        HashMap<String, String> files = new HashMap<String, String>(names.length);
        for (int i = 0; i < names.length; ++i) {
            files.put(names[i], contents[i]);
        }
        this.getCache().putAll(files);
    }

    @Override
    @ManagedOperation(description="Registers a Protobuf definition file", displayName="Register Protofile")
    public void registerProtofile(@Parameter(name="fileName", description="the name of the .proto file") String name, @Parameter(name="contents", description="contents of the file") String contents) {
        this.getCache().put((Object)name, (Object)contents);
    }

    public void registerProtofiles(String ... classPathResources) throws Exception {
        HashMap<String, String> files = new HashMap<String, String>(classPathResources.length);
        for (String classPathResource : classPathResources) {
            String absPath = classPathResource.startsWith("/") ? classPathResource : "/" + classPathResource;
            String path = classPathResource.startsWith("/") ? classPathResource.substring(1) : classPathResource;
            files.put(path, Util.read((InputStream)Util.getResourceAsStream((String)absPath, (ClassLoader)this.getClass().getClassLoader())));
        }
        this.getCache().putAll(files);
    }

    @Override
    @ManagedOperation(description="Display a protobuf definition file", displayName="Display Protofile")
    public String displayProtofile(@Parameter(name="fileName", description="the name of the .proto file") String fileName) {
        if (!fileName.endsWith(".proto")) {
            throw new IllegalArgumentException("The file name must have \".proto\" suffix");
        }
        return (String)this.getCache().get((Object)fileName);
    }

    SerializationContext getSerializationContext() {
        return this.serCtx;
    }

    public static SerializationContext getSerializationContext(EmbeddedCacheManager cacheManager) {
        if (cacheManager == null) {
            throw new IllegalArgumentException("cacheManager cannot be null");
        }
        ProtobufMetadataManager metadataManager = (ProtobufMetadataManager)cacheManager.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        if (metadataManager == null) {
            throw new IllegalStateException("ProtobufMetadataManager not initialised yet!");
        }
        return new DelegatingSerializationContext(metadataManager);
    }

    public static SerializationContext getSerializationContextInternal(EmbeddedCacheManager cacheManager) {
        DelegatingSerializationContext delegatingCtx = (DelegatingSerializationContext)ProtobufMetadataManager.getSerializationContext(cacheManager);
        return delegatingCtx.getDelegate();
    }
}

