/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.indexing;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.infinispan.commons.CacheException;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.query.remote.indexing.IndexingTagHandler;

class WrappedMessageTagHandler
implements TagHandler {
    private final Document document;
    private final LuceneOptions luceneOptions;
    private final SerializationContext serCtx;
    private Descriptor messageDescriptor;
    private byte[] bytes;
    private Number numericValue;
    private String stringValue;

    public WrappedMessageTagHandler(Document document, LuceneOptions luceneOptions, SerializationContext serCtx) {
        this.document = document;
        this.luceneOptions = luceneOptions;
        this.serCtx = serCtx;
    }

    public void onStart() {
    }

    public void onTag(int fieldNumber, String fieldName, Type type, JavaType javaType, Object value) {
        switch (fieldNumber) {
            case 8: {
                this.numericValue = Boolean.TRUE.equals(value) ? IndexingTagHandler.TRUE_INT : IndexingTagHandler.FALSE_INT;
                break;
            }
            case 9: 
            case 10: {
                this.stringValue = (String)value;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                this.numericValue = (Number)value;
                break;
            }
            case 16: {
                this.messageDescriptor = this.serCtx.getMessageDescriptor((String)value);
                break;
            }
            case 17: {
                this.bytes = (byte[])value;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected field : " + fieldNumber);
            }
        }
    }

    public void onStartNested(int fieldNumber, String fieldName, Descriptor messageDescriptor) {
        throw new IllegalStateException("No nested message is expected");
    }

    public void onEndNested(int fieldNumber, String fieldName, Descriptor messageDescriptor) {
        throw new IllegalStateException("No nested message is expected");
    }

    public void onEnd() {
        if (this.bytes != null) {
            if (this.messageDescriptor == null) {
                throw new IllegalStateException("Descriptor name is missing");
            }
            try {
                ProtobufParser.INSTANCE.parse((TagHandler)new IndexingTagHandler(this.messageDescriptor, this.document), this.messageDescriptor, this.bytes);
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        } else if (this.numericValue != null) {
            this.luceneOptions.addNumericFieldToDocument("theValue", (Object)this.numericValue, this.document);
        } else if (this.stringValue != null) {
            this.luceneOptions.addFieldToDocument("theValue", this.stringValue, this.document);
        }
    }
}

