/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.indexing;

import java.util.Set;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.compat.TypeConverter;
import org.infinispan.context.Flag;
import org.infinispan.interceptors.compat.BaseTypeConverterInterceptor;
import org.infinispan.query.remote.indexing.ProtobufValueWrapper;

public final class RemoteValueWrapperInterceptor
extends BaseTypeConverterInterceptor {
    private final ProtobufValueWrapperTypeConverter protobufTypeConverter = new ProtobufValueWrapperTypeConverter();
    private final PassThroughTypeConverter passThroughTypeConverter = new PassThroughTypeConverter();

    protected TypeConverter<Object, Object, Object, Object> determineTypeConverter(Set<Flag> flags) {
        return flags != null && flags.contains(Flag.OPERATION_HOTROD) ? this.protobufTypeConverter : this.passThroughTypeConverter;
    }

    private static class ProtobufValueWrapperTypeConverter
    extends PassThroughTypeConverter {
        private ProtobufValueWrapperTypeConverter() {
        }

        @Override
        public Object boxValue(Object value) {
            if (value instanceof byte[]) {
                return new ProtobufValueWrapper((byte[])value);
            }
            return value;
        }

        @Override
        public Object unboxValue(Object target) {
            if (target instanceof ProtobufValueWrapper) {
                return ((ProtobufValueWrapper)target).getBinary();
            }
            return target;
        }
    }

    private static class PassThroughTypeConverter
    implements TypeConverter<Object, Object, Object, Object> {
        private PassThroughTypeConverter() {
        }

        public Object boxKey(Object key) {
            return key;
        }

        public Object boxValue(Object value) {
            return value;
        }

        public Object unboxKey(Object target) {
            return target;
        }

        public Object unboxValue(Object target) {
            return target;
        }

        public boolean supportsInvocation(Flag flag) {
            return false;
        }

        public void setMarshaller(Marshaller marshaller) {
        }
    }
}

