/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import org.infinispan.objectfilter.impl.syntax.BooleShannonExpansion;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;

final class ProtobufIndexedFieldProvider
implements BooleShannonExpansion.IndexedFieldProvider {
    private final Descriptor messageDescriptor;

    public ProtobufIndexedFieldProvider(Descriptor messageDescriptor) {
        this.messageDescriptor = messageDescriptor;
    }

    public boolean isIndexed(String[] propertyPath) {
        Descriptor md = this.messageDescriptor;
        int i = 0;
        for (String p : propertyPath) {
            ++i;
            FieldDescriptor field = md.findFieldByName(p);
            if (field == null) break;
            if (field.getJavaType() != JavaType.MESSAGE) {
                if (i != propertyPath.length) break;
                IndexingMetadata indexingMetadata = (IndexingMetadata)this.messageDescriptor.getProcessedAnnotation("Indexed");
                return indexingMetadata == null || indexingMetadata.isFieldIndexed(field.getNumber());
            }
            md = field.getMessageType();
        }
        return false;
    }

    public boolean isStored(String[] propertyPath) {
        Descriptor md = this.messageDescriptor;
        int i = 0;
        for (String p : propertyPath) {
            ++i;
            FieldDescriptor field = md.findFieldByName(p);
            if (field == null) break;
            if (field.getJavaType() != JavaType.MESSAGE) {
                if (i != propertyPath.length) break;
                IndexingMetadata indexingMetadata = (IndexingMetadata)this.messageDescriptor.getProcessedAnnotation("Indexed");
                return indexingMetadata == null || indexingMetadata.isFieldStored(field.getNumber());
            }
            md = field.getMessageType();
        }
        return false;
    }
}

