/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.BaseCustomSequentialInterceptor;
import org.infinispan.interceptors.SequentialInterceptorChain;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.client.ProtobufMetadataManagerConstants;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;

final class ProtobufMetadataManagerInterceptor
extends BaseCustomSequentialInterceptor
implements ProtobufMetadataManagerConstants {
    private CommandsFactory commandsFactory;
    private SequentialInterceptorChain invoker;
    private SerializationContext serializationContext;
    private static final FileDescriptorSource.ProgressCallback EMPTY_CALLBACK = new FileDescriptorSource.ProgressCallback(){

        public void handleError(String fileName, DescriptorParserException exception) {
        }

        public void handleSuccess(String fileName) {
        }
    };
    private final AbstractVisitor serializationContextUpdaterVisitor = new AbstractVisitor(){

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            String key = (String)command.getKey();
            if (ProtobufMetadataManagerInterceptor.this.shouldIntercept(key)) {
                FileDescriptorSource source = new FileDescriptorSource().withProgressCallback(EMPTY_CALLBACK).addProtoFile(key, (String)command.getValue());
                try {
                    ProtobufMetadataManagerInterceptor.this.serializationContext.registerProtoFiles(source);
                }
                catch (IOException | DescriptorParserException e) {
                    throw new CacheException("Failed to parse proto file : " + key, e);
                }
            }
            return null;
        }

        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            Map map = command.getMap();
            FileDescriptorSource source = new FileDescriptorSource().withProgressCallback(EMPTY_CALLBACK);
            for (Object key : map.keySet()) {
                if (!ProtobufMetadataManagerInterceptor.this.shouldIntercept(key)) continue;
                source.addProtoFile((String)key, (String)map.get(key));
            }
            try {
                ProtobufMetadataManagerInterceptor.this.serializationContext.registerProtoFiles(source);
            }
            catch (IOException | DescriptorParserException e) {
                throw new CacheException(e);
            }
            return null;
        }

        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            String key = (String)command.getKey();
            if (ProtobufMetadataManagerInterceptor.this.shouldIntercept(key)) {
                FileDescriptorSource source = new FileDescriptorSource().withProgressCallback(EMPTY_CALLBACK).addProtoFile(key, (String)command.getNewValue());
                try {
                    ProtobufMetadataManagerInterceptor.this.serializationContext.registerProtoFiles(source);
                }
                catch (IOException | DescriptorParserException e) {
                    throw new CacheException("Failed to parse proto file : " + key, e);
                }
            }
            return null;
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            String key = (String)command.getKey();
            if (ProtobufMetadataManagerInterceptor.this.shouldIntercept(key)) {
                ProtobufMetadataManagerInterceptor.this.serializationContext.unregisterProtoFile(key);
            }
            return null;
        }

        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            for (String fileName : ProtobufMetadataManagerInterceptor.this.serializationContext.getFileDescriptors().keySet()) {
                ProtobufMetadataManagerInterceptor.this.serializationContext.unregisterProtoFile(fileName);
            }
            return null;
        }
    };

    ProtobufMetadataManagerInterceptor() {
    }

    @Inject
    public void init(CommandsFactory commandsFactory, SequentialInterceptorChain invoker, ProtobufMetadataManager protobufMetadataManager) {
        this.commandsFactory = commandsFactory;
        this.invoker = invoker;
        this.serializationContext = ((ProtobufMetadataManagerImpl)protobufMetadataManager).getSerializationContext();
    }

    public CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object result = ctx.forkInvocationSync((VisitableCommand)command);
        if (!ctx.isOriginLocal()) {
            for (WriteCommand wc : command.getModifications()) {
                wc.acceptVisitor((InvocationContext)ctx, (Visitor)this.serializationContextUpdaterVisitor);
            }
        }
        return ctx.shortCircuit(result);
    }

    public CompletableFuture<Void> visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object key = command.getKey();
        Object value = command.getValue();
        if (ctx.isOriginLocal()) {
            if (!(key instanceof String)) {
                throw new CacheException("The key must be a string");
            }
            if (!(value instanceof String)) {
                throw new CacheException("The value must be a string");
            }
            if (this.shouldIntercept(key)) {
                if (!command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER)) {
                    if (!((String)key).endsWith(".proto")) {
                        throw new CacheException("The key must end with \".proto\" : " + key);
                    }
                    LockControlCommand cmd = this.commandsFactory.buildLockControlCommand((Object)".errors", 0L, null);
                    this.invoker.invoke(ctx.clone(), (VisitableCommand)cmd);
                }
            } else {
                return ctx.continueInvocation();
            }
        }
        Object result = ctx.forkInvocationSync((VisitableCommand)command);
        if (command.isSuccessful()) {
            FileDescriptorSource source = new FileDescriptorSource().addProtoFile((String)key, (String)value);
            ProgressCallback progressCallback = null;
            if (ctx.isOriginLocal() && !command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER)) {
                progressCallback = new ProgressCallback(ctx);
                source.withProgressCallback((FileDescriptorSource.ProgressCallback)progressCallback);
            } else {
                source.withProgressCallback(EMPTY_CALLBACK);
            }
            try {
                this.serializationContext.registerProtoFiles(source);
            }
            catch (IOException | DescriptorParserException e) {
                throw new CacheException("Failed to parse proto file : " + key, e);
            }
            if (progressCallback != null) {
                this.updateGlobalErrors(ctx, progressCallback.getErrorFiles());
            }
        }
        return ctx.shortCircuit(result);
    }

    public CompletableFuture<Void> visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Map map = command.getMap();
        FileDescriptorSource source = new FileDescriptorSource();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (!(key instanceof String)) {
                throw new CacheException("The key must be a string");
            }
            if (!(value instanceof String)) {
                throw new CacheException("The value must be a string");
            }
            if (!this.shouldIntercept(key)) continue;
            if (!((String)key).endsWith(".proto")) {
                throw new CacheException("The key must end with \".proto\" : " + key);
            }
            source.addProtoFile((String)key, (String)value);
        }
        LockControlCommand cmd = this.commandsFactory.buildLockControlCommand((Object)".errors", 0L, null);
        this.invoker.invoke(ctx.clone(), (VisitableCommand)cmd);
        Object result = ctx.forkInvocationSync((VisitableCommand)command);
        ProgressCallback progressCallback = null;
        if (ctx.isOriginLocal()) {
            progressCallback = new ProgressCallback(ctx);
            source.withProgressCallback((FileDescriptorSource.ProgressCallback)progressCallback);
        } else {
            source.withProgressCallback(EMPTY_CALLBACK);
        }
        try {
            this.serializationContext.registerProtoFiles(source);
        }
        catch (IOException | DescriptorParserException e) {
            throw new CacheException(e);
        }
        if (progressCallback != null) {
            this.updateGlobalErrors(ctx, progressCallback.getErrorFiles());
        }
        return ctx.shortCircuit(result);
    }

    public CompletableFuture<Void> visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            if (!(command.getKey() instanceof String)) {
                throw new CacheException("The key must be a string");
            }
            String key = (String)command.getKey();
            if (this.shouldIntercept(key)) {
                Object cmd = this.commandsFactory.buildLockControlCommand((Object)".errors", 0L, null);
                this.invoker.invoke(ctx.clone(), (VisitableCommand)cmd);
                cmd = this.commandsFactory.buildRemoveCommand((Object)(key + ".errors"), null, 0L);
                this.invoker.invoke(ctx.clone(), (VisitableCommand)cmd);
                this.serializationContext.unregisterProtoFile(key);
                Map fileDescriptors = this.serializationContext.getFileDescriptors();
                StringBuilder sb = new StringBuilder();
                for (FileDescriptor fd : fileDescriptors.values()) {
                    if (fd.isResolved()) {
                        cmd = this.commandsFactory.buildRemoveCommand((Object)(fd.getName() + ".errors"), null, 0L);
                        this.invoker.invoke(ctx.clone(), (VisitableCommand)cmd);
                        continue;
                    }
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append(fd.getName());
                    PutKeyValueCommand put = this.commandsFactory.buildPutKeyValueCommand((Object)(fd.getName() + ".errors"), (Object)"One of the imported files is missing or has errors", null, 0L);
                    put.setPutIfAbsent(true);
                    this.invoker.invoke(ctx.clone(), (VisitableCommand)put);
                }
                cmd = sb.length() > 0 ? this.commandsFactory.buildPutKeyValueCommand((Object)".errors", (Object)sb.toString(), null, 0L) : this.commandsFactory.buildRemoveCommand((Object)".errors", null, 0L);
                this.invoker.invoke(ctx.clone(), (VisitableCommand)cmd);
            }
        }
        return ctx.continueInvocation();
    }

    public CompletableFuture<Void> visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object key = command.getKey();
        Object value = command.getNewValue();
        if (ctx.isOriginLocal()) {
            if (!(key instanceof String)) {
                throw new CacheException("The key must be a string");
            }
            if (!(value instanceof String)) {
                throw new CacheException("The value must be a string");
            }
            if (!this.shouldIntercept(key)) {
                return ctx.continueInvocation();
            }
            if (!((String)key).endsWith(".proto")) {
                throw new CacheException("The key must end with \".proto\" : " + key);
            }
            LockControlCommand cmd = this.commandsFactory.buildLockControlCommand((Object)".errors", 0L, null);
            this.invoker.invoke(ctx.clone(), (VisitableCommand)cmd);
            Object result = ctx.forkInvocationSync((VisitableCommand)command);
            if (command.isSuccessful()) {
                FileDescriptorSource source = new FileDescriptorSource().addProtoFile((String)key, (String)value);
                ProgressCallback progressCallback = null;
                if (ctx.isOriginLocal()) {
                    progressCallback = new ProgressCallback(ctx);
                    source.withProgressCallback((FileDescriptorSource.ProgressCallback)progressCallback);
                } else {
                    source.withProgressCallback(EMPTY_CALLBACK);
                }
                try {
                    this.serializationContext.registerProtoFiles(source);
                }
                catch (IOException | DescriptorParserException e) {
                    throw new CacheException("Failed to parse proto file : " + key, e);
                }
                if (progressCallback != null) {
                    this.updateGlobalErrors(ctx, progressCallback.getErrorFiles());
                }
            }
            return ctx.shortCircuit(result);
        }
        return ctx.continueInvocation();
    }

    public CompletableFuture<Void> visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        for (String fileName : this.serializationContext.getFileDescriptors().keySet()) {
            this.serializationContext.unregisterProtoFile(fileName);
        }
        return ctx.continueInvocation();
    }

    private boolean shouldIntercept(Object key) {
        return !((String)key).endsWith(".errors");
    }

    private void updateGlobalErrors(InvocationContext ctx, Set<String> errorFiles) {
        RemoveCommand cmd;
        if (errorFiles.isEmpty()) {
            cmd = this.commandsFactory.buildRemoveCommand((Object)".errors", null, 0L);
        } else {
            StringBuilder sb = new StringBuilder();
            for (String fileName : errorFiles) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(fileName);
            }
            cmd = this.commandsFactory.buildPutKeyValueCommand((Object)".errors", (Object)sb.toString(), null, 0L);
        }
        this.invoker.invoke(ctx.clone(), (VisitableCommand)cmd);
    }

    private final class ProgressCallback
    implements FileDescriptorSource.ProgressCallback {
        private final InvocationContext ctx;
        private final Set<String> errorFiles = new TreeSet<String>();

        private ProgressCallback(InvocationContext ctx) {
            this.ctx = ctx;
        }

        public Set<String> getErrorFiles() {
            return this.errorFiles;
        }

        public void handleError(String fileName, DescriptorParserException exception) {
            if (this.errorFiles.add(fileName)) {
                PutKeyValueCommand cmd = ProtobufMetadataManagerInterceptor.this.commandsFactory.buildPutKeyValueCommand((Object)(fileName + ".errors"), (Object)exception.getMessage(), null, 0L);
                ProtobufMetadataManagerInterceptor.this.invoker.invoke(this.ctx.clone(), (VisitableCommand)cmd);
            }
        }

        public void handleSuccess(String fileName) {
            RemoveCommand cmd = ProtobufMetadataManagerInterceptor.this.commandsFactory.buildRemoveCommand((Object)(fileName + ".errors"), null, 0L);
            ProtobufMetadataManagerInterceptor.this.invoker.invoke(this.ctx.clone(), (VisitableCommand)cmd);
        }
    }
}

