/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.continuous.impl.JPAContinuousQueryCacheEventFilterConverter;
import org.infinispan.query.remote.client.ContinuousQueryResult;
import org.infinispan.query.remote.impl.CompatibilityReflectionMatcher;
import org.infinispan.query.remote.impl.ExternalizerIds;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;

public final class JPAContinuousQueryProtobufCacheEventFilterConverter
extends JPAContinuousQueryCacheEventFilterConverter<Object, Object, Object> {
    private SerializationContext serCtx;
    private boolean usesValueWrapper;
    private boolean isCompatMode;

    public JPAContinuousQueryProtobufCacheEventFilterConverter(String jpaQuery, Map<String, Object> namedParameters, Class<? extends Matcher> matcherImplClass) {
        super(jpaQuery, namedParameters, matcherImplClass);
    }

    protected void injectDependencies(Cache cache) {
        this.serCtx = ProtobufMetadataManagerImpl.getSerializationContextInternal(cache.getCacheManager());
        Configuration cfg = cache.getCacheConfiguration();
        this.isCompatMode = cfg.compatibility().enabled();
        boolean bl = this.usesValueWrapper = cfg.indexing().index().isEnabled() && !this.isCompatMode;
        if (this.isCompatMode) {
            this.matcherImplClass = CompatibilityReflectionMatcher.class;
        }
        super.injectDependencies(cache);
    }

    public Object filterAndConvert(Object key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
        ObjectFilter.FilterResult f2;
        if (this.usesValueWrapper) {
            oldValue = oldValue != null ? ((ProtobufValueWrapper)oldValue).getBinary() : null;
            Object object = newValue = newValue != null ? ((ProtobufValueWrapper)newValue).getBinary() : null;
        }
        if (eventType.isExpired()) {
            oldValue = newValue;
            newValue = null;
        }
        ObjectFilter objectFilter = this.getObjectFilter();
        ObjectFilter.FilterResult f1 = oldValue == null ? null : objectFilter.filter(oldValue);
        ObjectFilter.FilterResult filterResult = f2 = newValue == null ? null : objectFilter.filter(newValue);
        if (f1 == null && f2 != null) {
            return this.makeFilterResult(ContinuousQueryResult.ResultType.JOINING, key, f2.getProjection() == null ? newValue : null, f2.getProjection());
        }
        if (f1 != null && f2 == null) {
            return this.makeFilterResult(ContinuousQueryResult.ResultType.LEAVING, key, null, null);
        }
        return null;
    }

    protected Object makeFilterResult(ContinuousQueryResult.ResultType resultType, Object key, Object value, Object[] projection) {
        try {
            if (this.isCompatMode) {
                key = ProtobufUtil.toWrappedByteArray((SerializationContext)this.serCtx, (Object)key);
                if (value != null) {
                    value = ProtobufUtil.toWrappedByteArray((SerializationContext)this.serCtx, (Object)value);
                }
            }
            Object result = new ContinuousQueryResult(resultType, (byte[])key, (byte[])value, projection);
            if (!this.isCompatMode) {
                result = ProtobufUtil.toWrappedByteArray((SerializationContext)this.serCtx, (Object)result);
            }
            return result;
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public String toString() {
        return "JPAContinuousQueryProtobufCacheEventFilterConverter{jpaQuery='" + this.jpaQuery + "'}";
    }

    public static final class Externalizer
    extends AbstractExternalizer<JPAContinuousQueryProtobufCacheEventFilterConverter> {
        public void writeObject(ObjectOutput output, JPAContinuousQueryProtobufCacheEventFilterConverter filterAndConverter) throws IOException {
            output.writeUTF(filterAndConverter.jpaQuery);
            Map namedParameters = filterAndConverter.namedParameters;
            if (namedParameters != null) {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)namedParameters.size());
                for (Map.Entry e : namedParameters.entrySet()) {
                    output.writeUTF((String)e.getKey());
                    output.writeObject(e.getValue());
                }
            } else {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)0);
            }
            output.writeObject(filterAndConverter.matcherImplClass);
        }

        public JPAContinuousQueryProtobufCacheEventFilterConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String jpaQuery = input.readUTF();
            int paramsSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            HashMap<String, Object> namedParameters = null;
            if (paramsSize != 0) {
                namedParameters = new HashMap<String, Object>(paramsSize);
                for (int i = 0; i < paramsSize; ++i) {
                    String paramName = input.readUTF();
                    Object paramValue = input.readObject();
                    namedParameters.put(paramName, paramValue);
                }
            }
            Class matcherImplClass = (Class)input.readObject();
            return new JPAContinuousQueryProtobufCacheEventFilterConverter(jpaQuery, namedParameters, matcherImplClass);
        }

        public Integer getId() {
            return ExternalizerIds.JPA_CONTINUOUS_QUERY_CACHE_EVENT_FILTER_CONVERTER;
        }

        public Set<Class<? extends JPAContinuousQueryProtobufCacheEventFilterConverter>> getTypeClasses() {
            return Collections.singleton(JPAContinuousQueryProtobufCacheEventFilterConverter.class);
        }
    }
}

