/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.bridge.util.impl.ToStringNullMarker;
import org.hibernate.search.engine.nulls.codec.impl.LuceneStringNullMarkerCodec;
import org.hibernate.search.engine.nulls.codec.impl.NullMarkerCodec;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;
import org.infinispan.query.remote.impl.RemoteQueryEngine;
import org.infinispan.query.remote.impl.SecurityActions;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.server.core.QueryFacade;

public final class QueryFacadeImpl
implements QueryFacade {
    private static final Log log = (Log)LogFactory.getLog(QueryFacadeImpl.class, Log.class);
    public static final String TYPE_FIELD_NAME = "$type$";
    public static final String NULL_TOKEN = "_null_";
    public static final NullMarkerCodec NULL_TOKEN_CODEC = new LuceneStringNullMarkerCodec((NullMarker)new ToStringNullMarker((Object)"_null_"));

    public byte[] query(AdvancedCache<byte[], byte[]> cache, byte[] query) {
        RemoteQueryEngine queryEngine = (RemoteQueryEngine)((Object)SecurityActions.getCacheComponentRegistry(cache).getComponent(RemoteQueryEngine.class));
        if (queryEngine == null) {
            throw log.queryingNotEnabled(cache.getName());
        }
        try {
            QueryRequest request = (QueryRequest)ProtobufUtil.fromByteArray((SerializationContext)queryEngine.getSerializationContext(), (byte[])query, (int)0, (int)query.length, QueryRequest.class);
            long startOffset = request.getStartOffset() == null ? -1L : request.getStartOffset();
            int maxResults = request.getMaxResults() == null ? -1 : request.getMaxResults();
            BaseQuery q = queryEngine.makeQuery(request.getQueryString(), request.getNamedParametersMap(), startOffset, maxResults);
            QueryResponse response = this.makeResponse(q);
            return ProtobufUtil.toByteArray((SerializationContext)queryEngine.getSerializationContext(), (Object)response);
        }
        catch (IOException e) {
            throw log.errorExecutingQuery(e);
        }
    }

    private QueryResponse makeResponse(BaseQuery query) {
        List list = query.list();
        int numResults = list.size();
        String[] projection = query.getProjection();
        int projSize = projection != null ? projection.length : 0;
        ArrayList<WrappedMessage> results = new ArrayList<WrappedMessage>(projSize == 0 ? numResults : numResults * projSize);
        for (Object o : list) {
            if (projSize == 0) {
                results.add(new WrappedMessage(o));
                continue;
            }
            Object[] row = (Object[])o;
            for (int i = 0; i < projSize; ++i) {
                results.add(new WrappedMessage(row[i]));
            }
        }
        QueryResponse response = new QueryResponse();
        response.setTotalResults((long)query.getResultSize());
        response.setNumResults(numResults);
        response.setProjectionSize(projSize);
        response.setResults(results);
        return response;
    }
}

