/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.query.remote.client.FilterResult;
import org.infinispan.query.remote.impl.ExternalizerIds;

public final class FilterResultExternalizer
extends AbstractExternalizer<FilterResult> {
    public void writeObject(ObjectOutput output, FilterResult filterResult) throws IOException {
        Object[] projection = filterResult.getProjection();
        if (projection == null) {
            output.writeInt(-1);
            output.writeObject(filterResult.getInstance());
        } else {
            output.writeInt(projection.length);
            for (Object prj : projection) {
                output.writeObject(prj);
            }
        }
        Comparable[] sortProjection = filterResult.getSortProjection();
        if (sortProjection == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(sortProjection.length);
            for (Comparable prj : sortProjection) {
                output.writeObject(prj);
            }
        }
    }

    public FilterResult readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Comparable[] sortProjection;
        Object[] projection;
        Object instance;
        int projLen = input.readInt();
        if (projLen == -1) {
            instance = input.readObject();
            projection = null;
        } else {
            instance = null;
            projection = new Object[projLen];
            for (int i = 0; i < projLen; ++i) {
                projection[i] = input.readObject();
            }
        }
        int sortProjLen = input.readInt();
        if (sortProjLen == -1) {
            sortProjection = null;
        } else {
            sortProjection = new Comparable[sortProjLen];
            for (int i = 0; i < sortProjLen; ++i) {
                sortProjection[i] = (Comparable)input.readObject();
            }
        }
        return new FilterResult(instance, projection, sortProjection);
    }

    public Integer getId() {
        return ExternalizerIds.JPA_FILTER_RESULT;
    }

    public Set<Class<? extends FilterResult>> getTypeClasses() {
        return Collections.singleton(FilterResult.class);
    }
}

