/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.bridge.util.impl.ToStringNullMarker;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.hibernate.search.engine.metadata.impl.BackReference;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.nulls.codec.impl.LuceneStringNullMarkerCodec;
import org.hibernate.search.engine.nulls.codec.impl.NullMarkerCodec;
import org.infinispan.protostream.MessageContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;

final class IndexingTagHandler
implements TagHandler {
    private static final NullMarkerCodec NULL_TOKEN_CODEC = new LuceneStringNullMarkerCodec((NullMarker)new ToStringNullMarker((Object)"_null_"));
    private static final LuceneOptions NOT_STORED_NOT_ANALYZED = new LuceneOptionsImpl(new DocumentFieldMetadata.Builder(new BackReference(), new BackReference(), null, Store.NO, Field.Index.NOT_ANALYZED, Field.TermVector.NO).indexNullAs(NULL_TOKEN_CODEC).boost(Float.valueOf(1.0f)).build(), 1.0f, 1.0f);
    private static final LuceneOptions STORED_NOT_ANALYZED = new LuceneOptionsImpl(new DocumentFieldMetadata.Builder(new BackReference(), new BackReference(), null, Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO).indexNullAs(NULL_TOKEN_CODEC).boost(Float.valueOf(1.0f)).build(), 1.0f, 1.0f);
    private final Document document;
    private MessageContext<? extends MessageContext> messageContext;

    IndexingTagHandler(Descriptor messageDescriptor, Document document) {
        this.document = document;
        this.messageContext = new MessageContext(null, null, messageDescriptor);
    }

    public void onStart() {
        NOT_STORED_NOT_ANALYZED.addFieldToDocument("$type$", this.messageContext.getMessageDescriptor().getFullName(), this.document);
    }

    public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
        this.messageContext.markField(fieldNumber);
        if (fieldDescriptor != null) {
            FieldMapping fieldMapping;
            IndexingMetadata indexingMetadata = (IndexingMetadata)this.messageContext.getMessageDescriptor().getProcessedAnnotation("Indexed");
            FieldMapping fieldMapping2 = fieldMapping = indexingMetadata != null ? indexingMetadata.getFieldMapping(fieldDescriptor.getName()) : null;
            if (indexingMetadata == null || fieldMapping != null && fieldMapping.index()) {
                this.addFieldToDocument(fieldDescriptor, tagValue, fieldMapping);
            }
        }
    }

    private void addFieldToDocument(FieldDescriptor fieldDescriptor, Object value, FieldMapping fieldMapping) {
        LuceneOptions luceneOptions;
        Type type = fieldDescriptor.getType();
        boolean isSortable = false;
        if (fieldMapping == null) {
            if (value == null) {
                value = "_null_";
                type = Type.STRING;
                luceneOptions = NOT_STORED_NOT_ANALYZED;
            } else {
                luceneOptions = STORED_NOT_ANALYZED;
            }
        } else {
            luceneOptions = fieldMapping.luceneOptions();
            isSortable = fieldMapping.sortable();
            if (value == null) {
                if (fieldMapping.indexNullAs() == null || fieldMapping.analyze()) {
                    return;
                }
                value = fieldMapping.indexNullAs();
            }
        }
        String fullFieldName = this.messageContext.getFullFieldName();
        fullFieldName = fullFieldName != null ? fullFieldName + "." + fieldDescriptor.getName() : fieldDescriptor.getName();
        switch (type) {
            case DOUBLE: 
            case FLOAT: 
            case INT64: 
            case UINT64: 
            case INT32: 
            case FIXED64: 
            case FIXED32: 
            case UINT32: 
            case SFIXED32: 
            case SFIXED64: 
            case SINT32: 
            case SINT64: 
            case ENUM: {
                if (isSortable) {
                    luceneOptions.addNumericDocValuesFieldToDocument(fullFieldName, (Number)value, this.document);
                }
                luceneOptions.addNumericFieldToDocument(fullFieldName, value, this.document);
                break;
            }
            default: {
                String indexedString = String.valueOf(value);
                if (isSortable) {
                    luceneOptions.addSortedDocValuesFieldToDocument(fullFieldName, indexedString, this.document);
                }
                luceneOptions.addFieldToDocument(fullFieldName, indexedString, this.document);
            }
        }
    }

    public void onStartNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        this.messageContext.markField(fieldNumber);
        this.pushContext(fieldDescriptor.getName(), fieldDescriptor.getMessageType());
    }

    public void onEndNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        this.popContext();
    }

    public void onEnd() {
        this.indexMissingFields();
    }

    private void pushContext(String fieldName, Descriptor messageDescriptor) {
        this.messageContext = new MessageContext(this.messageContext, fieldName, messageDescriptor);
    }

    private void popContext() {
        this.indexMissingFields();
        this.messageContext = this.messageContext.getParentContext();
    }

    private void indexMissingFields() {
        for (FieldDescriptor fieldDescriptor : this.messageContext.getMessageDescriptor().getFields()) {
            FieldMapping fieldMapping;
            if (this.messageContext.isFieldMarked(fieldDescriptor.getNumber())) continue;
            Object defaultValue = fieldDescriptor.getJavaType() == JavaType.MESSAGE || fieldDescriptor.hasDefaultValue() ? fieldDescriptor.getDefaultValue() : null;
            IndexingMetadata indexingMetadata = (IndexingMetadata)this.messageContext.getMessageDescriptor().getProcessedAnnotation("Indexed");
            FieldMapping fieldMapping2 = fieldMapping = indexingMetadata != null ? indexingMetadata.getFieldMapping(fieldDescriptor.getName()) : null;
            if (indexingMetadata != null && (fieldMapping == null || !fieldMapping.index())) continue;
            this.addFieldToDocument(fieldDescriptor, defaultValue, fieldMapping);
        }
    }
}

