/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.objectfilter.impl.syntax.parser.ReflectionEntityNamesResolver;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;
import org.infinispan.query.remote.impl.AbstractCompatRemoteQueryManager;
import org.infinispan.query.remote.impl.CompatibilityReflectionMatcher;
import org.infinispan.query.remote.impl.util.LazyRef;

class GenericCompatRemoteQueryManager
extends AbstractCompatRemoteQueryManager {
    private LazyRef<Transcoder> transcoder = new LazyRef<Transcoder>(() -> this.encoderRegistry.getTranscoder(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JSON));

    GenericCompatRemoteQueryManager(ComponentRegistry cr) {
        super(cr);
    }

    @Override
    EntityNameResolver createEntityNamesResolver(ComponentRegistry cr) {
        ReflectionEntityNamesResolver entityNameResolver;
        ClassLoader classLoader = (ClassLoader)cr.getGlobalComponentRegistry().getComponent(ClassLoader.class);
        ReflectionEntityNamesResolver reflectionEntityNamesResolver = new ReflectionEntityNamesResolver(classLoader);
        if (this.isIndexed) {
            Set knownClasses = ((QueryInterceptor)cr.getComponent(QueryInterceptor.class)).getKnownClasses();
            entityNameResolver = name -> knownClasses.stream().filter(c -> c.getName().equals(name)).findFirst().orElse(reflectionEntityNamesResolver.resolve(name));
        } else {
            entityNameResolver = reflectionEntityNamesResolver;
        }
        return entityNameResolver;
    }

    @Override
    CompatibilityReflectionMatcher createMatcher(EntityNameResolver entityNameResolver, SerializationContext ctx, SearchIntegrator searchIntegrator) {
        if (searchIntegrator == null) {
            return new CompatibilityReflectionMatcher(entityNameResolver, null);
        }
        return new CompatibilityReflectionMatcher(entityNameResolver, null, searchIntegrator);
    }

    @Override
    public QueryRequest decodeQueryRequest(byte[] queryRequest) {
        return (QueryRequest)this.getValueEncoder().toStorage((Object)queryRequest);
    }

    @Override
    public List<Object> encodeQueryResults(List<Object> results) {
        return results.stream().map(o -> this.transcoder.get().transcode(o, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JSON)).collect(Collectors.toList());
    }

    @Override
    public byte[] encodeQueryResponse(QueryResponse queryResponse) {
        Object o = this.getValueEncoder().fromStorage((Object)queryResponse);
        return (byte[])o;
    }
}

