/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.indexing.IndexingTagHandler;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.logging.Log;

final class WrappedMessageTagHandler
implements TagHandler {
    private static final Log log = (Log)LogFactory.getLog(WrappedMessageTagHandler.class, Log.class);
    private final ProtobufValueWrapper valueWrapper;
    private final Document document;
    private final LuceneOptions luceneOptions;
    private final SerializationContext serCtx;
    private Descriptor messageDescriptor;
    private byte[] bytes;
    private Number numericValue;
    private String stringValue;

    WrappedMessageTagHandler(ProtobufValueWrapper valueWrapper, Document document, LuceneOptions luceneOptions, SerializationContext serCtx) {
        this.valueWrapper = valueWrapper;
        this.document = document;
        this.luceneOptions = luceneOptions;
        this.serCtx = serCtx;
    }

    public void onStart(GenericDescriptor descriptor) {
    }

    public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object value) {
        switch (fieldNumber) {
            case 8: {
                this.stringValue = value != null ? value.toString() : null;
                break;
            }
            case 9: 
            case 10: {
                this.stringValue = (String)value;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                this.numericValue = (Number)value;
                break;
            }
            case 16: {
                this.messageDescriptor = this.serCtx.getMessageDescriptor((String)value);
                break;
            }
            case 19: {
                String typeName = this.serCtx.getTypeNameById((Integer)value);
                this.messageDescriptor = this.serCtx.getMessageDescriptor(typeName);
                break;
            }
            case 17: {
                this.bytes = (byte[])value;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected field : " + fieldNumber);
            }
        }
    }

    public void onStartNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        throw new IllegalStateException("No nested message is expected");
    }

    public void onEndNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        throw new IllegalStateException("No nested message is expected");
    }

    public void onEnd() {
        if (this.bytes != null) {
            if (this.messageDescriptor == null) {
                throw new IllegalStateException("Type name or type id is missing");
            }
            IndexingMetadata indexingMetadata = (IndexingMetadata)this.messageDescriptor.getProcessedAnnotation("Indexed");
            if (indexingMetadata == null && IndexingMetadata.isLegacyIndexingEnabled(this.messageDescriptor) || indexingMetadata != null && indexingMetadata.isIndexed()) {
                if (indexingMetadata == null) {
                    log.legacyIndexingIsDeprecated(this.messageDescriptor.getFullName(), this.messageDescriptor.getFileDescriptor().getName());
                }
                this.valueWrapper.setMessageDescriptor(this.messageDescriptor);
                try {
                    ProtobufParser.INSTANCE.parse((TagHandler)new IndexingTagHandler(this.messageDescriptor, this.document), this.messageDescriptor, this.bytes);
                }
                catch (IOException e) {
                    throw new CacheException((Throwable)e);
                }
            }
        } else if (this.numericValue != null) {
            this.luceneOptions.addNumericFieldToDocument("theValue", (Object)this.numericValue, this.document);
        } else if (this.stringValue != null) {
            this.luceneOptions.addFieldToDocument("theValue", this.stringValue, this.document);
        }
    }
}

