/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.io.IOException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.indexing.WrappedMessageTagHandler;

public final class ProtobufValueWrapperInterceptor
extends DDAsyncInterceptor {
    private final EmbeddedCacheManager cacheManager;
    private SerializationContext serializationContext = null;
    private Descriptor wrapperDescriptor = null;

    public ProtobufValueWrapperInterceptor(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        this.intercept(command.getValue());
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        for (Object value : command.getMap().values()) {
            this.intercept(value);
        }
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        this.intercept(command.getOldValue());
        this.intercept(command.getNewValue());
        return super.visitReplaceCommand(ctx, command);
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        this.intercept(command.getValue());
        return super.visitRemoveCommand(ctx, command);
    }

    private void intercept(Object value) {
        if (value instanceof ProtobufValueWrapper) {
            this.discoverMessageType((ProtobufValueWrapper)value);
        }
    }

    private void discoverMessageType(ProtobufValueWrapper valueWrapper) {
        if (this.serializationContext == null) {
            this.serializationContext = ProtobufMetadataManagerImpl.getSerializationContextInternal(this.cacheManager);
        }
        if (this.wrapperDescriptor == null) {
            this.wrapperDescriptor = this.serializationContext.getMessageDescriptor("org.infinispan.protostream.WrappedMessage");
        }
        try {
            ProtobufParser.INSTANCE.parse((TagHandler)new WrappedMessageTagHandler(valueWrapper, this.serializationContext), this.wrapperDescriptor, valueWrapper.getBinary());
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

