/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Collection;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.client.BaseProtoStreamMarshaller;
import org.infinispan.query.remote.client.ProtostreamSerializationContextInitializer;
import org.infinispan.query.remote.impl.ExternalizerIds;
import org.infinispan.query.remote.impl.GenericCompatRemoteQueryManager;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.ProtobufRemoteQueryManager;
import org.infinispan.query.remote.impl.ProtobufWrapper;
import org.infinispan.query.remote.impl.ProtostreamCompatRemoteQueryManager;
import org.infinispan.query.remote.impl.RemoteQueryDefinitionExternalizer;
import org.infinispan.query.remote.impl.RemoteQueryManager;
import org.infinispan.query.remote.impl.dataconversion.ProtostreamBinaryTranscoder;
import org.infinispan.query.remote.impl.dataconversion.ProtostreamJsonTranscoder;
import org.infinispan.query.remote.impl.dataconversion.ProtostreamObjectTranscoder;
import org.infinispan.query.remote.impl.dataconversion.ProtostreamTextTranscoder;
import org.infinispan.query.remote.impl.filter.ContinuousQueryResultExternalizer;
import org.infinispan.query.remote.impl.filter.FilterResultExternalizer;
import org.infinispan.query.remote.impl.filter.IckleBinaryProtobufFilterAndConverter;
import org.infinispan.query.remote.impl.filter.IckleContinuousQueryProtobufCacheEventFilterConverter;
import org.infinispan.query.remote.impl.filter.IckleProtobufCacheEventFilterConverter;
import org.infinispan.query.remote.impl.filter.IckleProtobufFilterAndConverter;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapperSearchWorkCreator;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.registry.InternalCacheRegistry;

public final class LifecycleManager
implements ModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleManager.class, Log.class);
    private MBeanServer mbeanServer;

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        Map externalizerMap = globalCfg.serialization().advancedExternalizers();
        externalizerMap.put(ExternalizerIds.PROTOBUF_VALUE_WRAPPER, new ProtobufValueWrapper.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_PROTOBUF_CACHE_EVENT_FILTER_CONVERTER, new IckleProtobufCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_PROTOBUF_FILTER_AND_CONVERTER, new IckleProtobufFilterAndConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CONTINUOUS_QUERY_CACHE_EVENT_FILTER_CONVERTER, new IckleContinuousQueryProtobufCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_BINARY_PROTOBUF_FILTER_AND_CONVERTER, new IckleBinaryProtobufFilterAndConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CONTINUOUS_QUERY_RESULT, new ContinuousQueryResultExternalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_FILTER_RESULT, new FilterResultExternalizer());
        externalizerMap.put(ExternalizerIds.REMOTE_QUERY_DEFINITION, new RemoteQueryDefinitionExternalizer());
    }

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        EncoderRegistry encoderRegistry = (EncoderRegistry)gcr.getComponent(EncoderRegistry.class);
        encoderRegistry.registerWrapper((Wrapper)ProtobufWrapper.INSTANCE);
        this.initProtobufMetadataManager(gcr.getGlobalConfiguration(), gcr);
    }

    private void initProtobufMetadataManager(GlobalConfiguration globalCfg, GlobalComponentRegistry gcr) {
        ProtobufMetadataManagerImpl protobufMetadataManager = new ProtobufMetadataManagerImpl();
        gcr.registerComponent((Object)protobufMetadataManager, ProtobufMetadataManager.class);
        this.registerProtobufMetadataManagerMBean(protobufMetadataManager, gcr);
        SerializationContext serCtx = protobufMetadataManager.getSerializationContext();
        ClassLoader classLoader = globalCfg.classLoader();
        this.processProtostreamSerializationContextInitializers(classLoader, serCtx);
        EncoderRegistry encoderRegistry = (EncoderRegistry)gcr.getComponent(EncoderRegistry.class);
        encoderRegistry.registerTranscoder((Transcoder)new ProtostreamJsonTranscoder(serCtx));
        encoderRegistry.registerTranscoder((Transcoder)new ProtostreamTextTranscoder(serCtx));
        encoderRegistry.registerTranscoder((Transcoder)new ProtostreamObjectTranscoder(serCtx));
        encoderRegistry.registerTranscoder((Transcoder)new ProtostreamBinaryTranscoder());
    }

    private void processProtostreamSerializationContextInitializers(ClassLoader classLoader, SerializationContext serCtx) {
        Collection initializers = ServiceFinder.load(ProtostreamSerializationContextInitializer.class, (ClassLoader[])new ClassLoader[]{classLoader});
        for (ProtostreamSerializationContextInitializer psci : initializers) {
            try {
                psci.init(serCtx);
            }
            catch (Exception e) {
                throw log.errorInitializingSerCtx(e);
            }
        }
    }

    private void registerProtobufMetadataManagerMBean(ProtobufMetadataManagerImpl protobufMetadataManager, GlobalComponentRegistry gcr) {
        GlobalConfiguration globalCfg = gcr.getGlobalConfiguration();
        if (this.mbeanServer == null) {
            this.mbeanServer = JmxUtil.lookupMBeanServer((GlobalConfiguration)globalCfg);
        }
        String groupName = "type=RemoteQuery,name=" + ObjectName.quote(globalCfg.globalJmxStatistics().cacheManagerName());
        String jmxDomain = JmxUtil.buildJmxDomain((GlobalConfiguration)globalCfg, (MBeanServer)this.mbeanServer, (String)groupName);
        ComponentMetadataRepo metadataRepo = gcr.getComponentMetadataRepo();
        ManageableComponentMetadata metadata = metadataRepo.findComponentMetadata(ProtobufMetadataManagerImpl.class).toManageableComponentMetadata();
        try {
            ResourceDMBean mBean = new ResourceDMBean((Object)protobufMetadataManager, metadata);
            ObjectName objName = new ObjectName(jmxDomain + ":" + groupName + ",component=" + metadata.getJmxObjectName());
            protobufMetadataManager.setObjectName(objName);
            JmxUtil.registerMBean((Object)mBean, (ObjectName)objName, (MBeanServer)this.mbeanServer);
        }
        catch (Exception e) {
            throw new CacheException("Unable to register ProtobufMetadataManager MBean", (Throwable)e);
        }
    }

    public void cacheManagerStopping(GlobalComponentRegistry gcr) {
        this.unregisterProtobufMetadataManagerMBean(gcr);
    }

    private void unregisterProtobufMetadataManagerMBean(GlobalComponentRegistry gcr) {
        if (this.mbeanServer != null) {
            try {
                ProtobufMetadataManager protobufMetadataManager = (ProtobufMetadataManager)gcr.getComponent(ProtobufMetadataManager.class);
                if (protobufMetadataManager != null) {
                    JmxUtil.unregisterMBean((ObjectName)protobufMetadataManager.getObjectName(), (MBeanServer)this.mbeanServer);
                }
            }
            catch (Exception e) {
                throw new CacheException("Unable to unregister ProtobufMetadataManager MBean", (Throwable)e);
            }
        }
    }

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        GlobalComponentRegistry gcr = cr.getGlobalComponentRegistry();
        InternalCacheRegistry icr = (InternalCacheRegistry)gcr.getComponent(InternalCacheRegistry.class);
        if (!icr.isInternalCache(cacheName)) {
            ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)gcr.getComponent(ProtobufMetadataManager.class);
            protobufMetadataManager.addCacheDependency(cacheName);
        }
    }

    private RemoteQueryManager buildQueryManager(Configuration cfg, SerializationContext ctx, ComponentRegistry cr) {
        ContentTypeConfiguration valueEncoding = cfg.encoding().valueDataType();
        boolean compatEnabled = cfg.compatibility().enabled();
        if (!compatEnabled) {
            if (valueEncoding != null && (!valueEncoding.isEncodingChanged() || valueEncoding.mediaType() != null && valueEncoding.mediaType().equals((Object)MediaType.APPLICATION_PROTOSTREAM))) {
                return new ProtobufRemoteQueryManager(ctx, cr);
            }
            return new GenericCompatRemoteQueryManager(cr);
        }
        Marshaller compatMarshaller = cfg.compatibility().marshaller();
        if (compatMarshaller instanceof BaseProtoStreamMarshaller) {
            return new ProtostreamCompatRemoteQueryManager(cr);
        }
        return new GenericCompatRemoteQueryManager(cr);
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
        InternalCacheRegistry icr = (InternalCacheRegistry)cr.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        if (!icr.isInternalCache(cacheName)) {
            Configuration cfg = (Configuration)cr.getComponent(Configuration.class);
            ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)cr.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
            SerializationContext serCtx = protobufMetadataManager.getSerializationContext();
            RemoteQueryManager remoteQueryManager = this.buildQueryManager(cfg, serCtx, cr);
            Matcher matcher = remoteQueryManager.getMatcher();
            cr.registerComponent((Object)matcher, matcher.getClass());
            cr.registerComponent((Object)remoteQueryManager, RemoteQueryManager.class);
            if (cfg.indexing().index().isEnabled()) {
                log.debugf("Wrapping the SearchWorkCreator for indexed cache %s", cacheName);
                QueryInterceptor queryInterceptor = (QueryInterceptor)cr.getComponent(QueryInterceptor.class);
                queryInterceptor.setSearchWorkCreator(new ProtobufValueWrapperSearchWorkCreator(queryInterceptor.getSearchWorkCreator(), serCtx).get());
            }
        }
    }

    public void cacheManagerStopped(GlobalComponentRegistry gcr) {
        this.mbeanServer = null;
    }
}

