/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Collection;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.cache.CustomInterceptorsConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.BatchingInterceptor;
import org.infinispan.interceptors.impl.InvocationContextInterceptor;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.client.Externalizers;
import org.infinispan.query.remote.client.ProtostreamSerializationContextInitializer;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.impl.ExternalizerIds;
import org.infinispan.query.remote.impl.ObjectRemoteQueryManager;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.ProtobufRemoteQueryManager;
import org.infinispan.query.remote.impl.ProtobufWrapper;
import org.infinispan.query.remote.impl.RemoteQueryDefinitionExternalizer;
import org.infinispan.query.remote.impl.RemoteQueryManager;
import org.infinispan.query.remote.impl.dataconversion.ProtostreamBinaryTranscoder;
import org.infinispan.query.remote.impl.dataconversion.ProtostreamJsonTranscoder;
import org.infinispan.query.remote.impl.dataconversion.ProtostreamObjectTranscoder;
import org.infinispan.query.remote.impl.dataconversion.ProtostreamTextTranscoder;
import org.infinispan.query.remote.impl.filter.ContinuousQueryResultExternalizer;
import org.infinispan.query.remote.impl.filter.FilterResultExternalizer;
import org.infinispan.query.remote.impl.filter.IckleBinaryProtobufFilterAndConverter;
import org.infinispan.query.remote.impl.filter.IckleContinuousQueryProtobufCacheEventFilterConverter;
import org.infinispan.query.remote.impl.filter.IckleProtobufCacheEventFilterConverter;
import org.infinispan.query.remote.impl.filter.IckleProtobufFilterAndConverter;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapperInterceptor;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.registry.InternalCacheRegistry;

public final class LifecycleManager
implements ModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleManager.class, Log.class);

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        Map externalizerMap = globalCfg.serialization().advancedExternalizers();
        externalizerMap.put(ExternalizerIds.PROTOBUF_VALUE_WRAPPER, new ProtobufValueWrapper.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_PROTOBUF_CACHE_EVENT_FILTER_CONVERTER, new IckleProtobufCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_PROTOBUF_FILTER_AND_CONVERTER, new IckleProtobufFilterAndConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CONTINUOUS_QUERY_CACHE_EVENT_FILTER_CONVERTER, new IckleContinuousQueryProtobufCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_BINARY_PROTOBUF_FILTER_AND_CONVERTER, new IckleBinaryProtobufFilterAndConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CONTINUOUS_QUERY_RESULT, new ContinuousQueryResultExternalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_FILTER_RESULT, new FilterResultExternalizer());
        externalizerMap.put(ExternalizerIds.REMOTE_QUERY_DEFINITION, new RemoteQueryDefinitionExternalizer());
    }

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)gcr.getComponent(EmbeddedCacheManager.class);
        EncoderRegistry encoderRegistry = (EncoderRegistry)gcr.getComponent(EncoderRegistry.class);
        encoderRegistry.registerWrapper((Wrapper)ProtobufWrapper.INSTANCE);
        this.initProtobufMetadataManager((DefaultCacheManager)cacheManager, gcr);
        ClassWhiteList classWhiteList = cacheManager.getClassWhiteList();
        classWhiteList.addClasses(new Class[]{QueryRequest.class, Externalizers.QueryRequestExternalizer.class});
    }

    private void initProtobufMetadataManager(DefaultCacheManager cacheManager, GlobalComponentRegistry gcr) {
        ProtobufMetadataManagerImpl protobufMetadataManager = new ProtobufMetadataManagerImpl();
        gcr.registerComponent((Object)protobufMetadataManager, ProtobufMetadataManager.class);
        this.registerProtobufMetadataManagerMBean(protobufMetadataManager, gcr, cacheManager.getName());
        ClassLoader classLoader = cacheManager.getCacheManagerConfiguration().classLoader();
        this.processContextInitializers(classLoader, protobufMetadataManager);
        SerializationContext serCtx = protobufMetadataManager.getSerializationContext();
        EncoderRegistry encoderRegistry = (EncoderRegistry)gcr.getComponent(EncoderRegistry.class);
        encoderRegistry.registerTranscoder((Transcoder)new ProtostreamJsonTranscoder(serCtx));
        encoderRegistry.registerTranscoder((Transcoder)new ProtostreamTextTranscoder(serCtx));
        encoderRegistry.registerTranscoder((Transcoder)new ProtostreamObjectTranscoder(serCtx, classLoader));
        encoderRegistry.registerTranscoder((Transcoder)new ProtostreamBinaryTranscoder());
    }

    private void processContextInitializers(ClassLoader classLoader, ProtobufMetadataManagerImpl metadataManager) {
        Collection initializers = ServiceFinder.load(ProtostreamSerializationContextInitializer.class, (ClassLoader[])new ClassLoader[]{classLoader});
        initializers.forEach(initCtx -> {
            try {
                initCtx.init(metadataManager.getSerializationContext());
            }
            catch (Exception e) {
                throw log.errorInitializingSerCtx(e);
            }
        });
    }

    private void registerProtobufMetadataManagerMBean(ProtobufMetadataManager protobufMetadataManager, GlobalComponentRegistry gcr, String cacheManagerName) {
        GlobalConfiguration globalCfg = gcr.getGlobalConfiguration();
        MBeanServer mBeanServer = JmxUtil.lookupMBeanServer((GlobalConfiguration)globalCfg);
        String groupName = "type=RemoteQuery,name=" + ObjectName.quote(cacheManagerName);
        String jmxDomain = JmxUtil.buildJmxDomain((GlobalConfiguration)globalCfg, (MBeanServer)mBeanServer, (String)groupName);
        ComponentMetadataRepo metadataRepo = gcr.getComponentMetadataRepo();
        ManageableComponentMetadata metadata = metadataRepo.findComponentMetadata(ProtobufMetadataManagerImpl.class).toManageableComponentMetadata();
        try {
            ResourceDMBean mBean = new ResourceDMBean((Object)protobufMetadataManager, metadata);
            ObjectName objName = new ObjectName(jmxDomain + ":" + groupName + ",component=" + metadata.getJmxObjectName());
            protobufMetadataManager.setObjectName(objName);
            JmxUtil.registerMBean((Object)mBean, (ObjectName)objName, (MBeanServer)mBeanServer);
        }
        catch (Exception e) {
            throw new CacheException("Unable to register ProtobufMetadataManager MBean", (Throwable)e);
        }
    }

    public void cacheManagerStopping(GlobalComponentRegistry gcr) {
        this.unregisterProtobufMetadataManagerMBean(gcr);
    }

    private void unregisterProtobufMetadataManagerMBean(GlobalComponentRegistry gcr) {
        try {
            ObjectName objName = ((ProtobufMetadataManager)gcr.getComponent(ProtobufMetadataManager.class)).getObjectName();
            MBeanServer mBeanServer = JmxUtil.lookupMBeanServer((GlobalConfiguration)gcr.getGlobalConfiguration());
            JmxUtil.unregisterMBean((ObjectName)objName, (MBeanServer)mBeanServer);
        }
        catch (Exception e) {
            throw new CacheException("Unable to unregister ProtobufMetadataManager MBean", (Throwable)e);
        }
    }

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        GlobalComponentRegistry gcr = cr.getGlobalComponentRegistry();
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)gcr.getComponent(EmbeddedCacheManager.class);
        InternalCacheRegistry icr = (InternalCacheRegistry)gcr.getComponent(InternalCacheRegistry.class);
        if (!icr.isInternalCache(cacheName)) {
            ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)gcr.getComponent(ProtobufMetadataManager.class);
            protobufMetadataManager.addCacheDependency(cacheName);
            if (cfg.indexing().index().isEnabled()) {
                log.infof("Registering ProtobufValueWrapperInterceptor for cache %s", cacheName);
                this.createProtobufValueWrapperInterceptor(cr, cfg, cacheManager);
            }
        }
    }

    private void createProtobufValueWrapperInterceptor(ComponentRegistry cr, Configuration cfg, EmbeddedCacheManager cacheManager) {
        ProtobufValueWrapperInterceptor wrapperInterceptor = (ProtobufValueWrapperInterceptor)((Object)cr.getComponent(ProtobufValueWrapperInterceptor.class));
        if (wrapperInterceptor == null) {
            wrapperInterceptor = new ProtobufValueWrapperInterceptor(cacheManager);
            AsyncInterceptorChain ic = (AsyncInterceptorChain)cr.getComponent(AsyncInterceptorChain.class);
            ConfigurationBuilder builder = new ConfigurationBuilder().read(cfg);
            InterceptorConfigurationBuilder interceptorBuilder = builder.customInterceptors().addInterceptor();
            interceptorBuilder.interceptor((AsyncInterceptor)wrapperInterceptor);
            if (cfg.invocationBatching().enabled()) {
                if (ic != null) {
                    ic.addInterceptorAfter((AsyncInterceptor)wrapperInterceptor, BatchingInterceptor.class);
                }
                interceptorBuilder.after(BatchingInterceptor.class);
            } else {
                if (ic != null) {
                    ic.addInterceptorAfter((AsyncInterceptor)wrapperInterceptor, InvocationContextInterceptor.class);
                }
                interceptorBuilder.after(InvocationContextInterceptor.class);
            }
            if (ic != null) {
                cr.registerComponent((Object)wrapperInterceptor, ProtobufValueWrapperInterceptor.class);
            }
            cfg.customInterceptors().interceptors(builder.build().customInterceptors().interceptors());
        }
    }

    private RemoteQueryManager buildQueryManager(Configuration cfg, SerializationContext ctx, ComponentRegistry cr) {
        boolean isObjectStorage;
        ContentTypeConfiguration valueEncoding = cfg.encoding().valueDataType();
        MediaType valueStorageMediaType = valueEncoding.mediaType();
        boolean bl = isObjectStorage = valueStorageMediaType != null && valueStorageMediaType.match(MediaType.APPLICATION_OBJECT);
        if (isObjectStorage) {
            return new ObjectRemoteQueryManager(cr);
        }
        return new ProtobufRemoteQueryManager(ctx, cr);
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
        InternalCacheRegistry icr = (InternalCacheRegistry)cr.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        if (!icr.isInternalCache(cacheName)) {
            Configuration cfg = (Configuration)cr.getComponent(Configuration.class);
            if (cfg.indexing().index().isEnabled()) {
                if (!this.verifyChainContainsProtobufValueWrapperInterceptor(cr)) {
                    throw new IllegalStateException("It was expected to find the ProtobufValueWrapperInterceptor registered in the InterceptorChain but it wasn't found");
                }
            } else if (this.verifyChainContainsProtobufValueWrapperInterceptor(cr)) {
                throw new IllegalStateException("It was NOT expected to find the ProtobufValueWrapperInterceptor registered in the InterceptorChain as indexing was disabled, but it was found");
            }
            ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)cr.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
            SerializationContext serCtx = protobufMetadataManager.getSerializationContext();
            RemoteQueryManager remoteQueryManager = this.buildQueryManager(cfg, serCtx, cr);
            cr.registerComponent((Object)remoteQueryManager, RemoteQueryManager.class);
        }
    }

    private boolean verifyChainContainsProtobufValueWrapperInterceptor(ComponentRegistry cr) {
        AsyncInterceptorChain interceptorChain = (AsyncInterceptorChain)cr.getComponent(AsyncInterceptorChain.class);
        return interceptorChain != null && interceptorChain.containsInterceptorType(ProtobufValueWrapperInterceptor.class, true);
    }

    public void cacheStopped(ComponentRegistry cr, String cacheName) {
        Configuration cfg = (Configuration)cr.getComponent(Configuration.class);
        this.removeRemoteIndexingInterceptorFromConfig(cfg);
    }

    private void removeRemoteIndexingInterceptorFromConfig(Configuration cfg) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        CustomInterceptorsConfigurationBuilder customInterceptorsBuilder = builder.customInterceptors();
        for (InterceptorConfiguration interceptorConfig : cfg.customInterceptors().interceptors()) {
            if (interceptorConfig.asyncInterceptor() instanceof ProtobufValueWrapperInterceptor) continue;
            customInterceptorsBuilder.addInterceptor().read(interceptorConfig);
        }
        cfg.customInterceptors().interceptors(builder.build().customInterceptors().interceptors());
    }
}

