/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;
import org.infinispan.query.remote.impl.BaseRemoteQueryEngine;
import org.infinispan.query.remote.impl.ProtobufFieldIndexingMetadata;
import org.infinispan.query.remote.impl.ProtobufWrapper;
import org.infinispan.query.remote.impl.RemoteQueryEngine;
import org.infinispan.query.remote.impl.RemoteQueryManager;

class ProtobufRemoteQueryManager
implements RemoteQueryManager {
    private final BaseRemoteQueryEngine queryEngine;
    private final DataConversion keyDataConversion;
    private final DataConversion valueDataConversion;
    private final Transcoder protobufTranscoder;

    ProtobufRemoteQueryManager(SerializationContext serCtx, ComponentRegistry cr) {
        ProtobufMatcher matcher = new ProtobufMatcher(serCtx, ProtobufFieldIndexingMetadata::new);
        AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
        Configuration configuration = cache.getCacheConfiguration();
        this.keyDataConversion = cache.getKeyDataConversion();
        this.valueDataConversion = cache.getValueDataConversion();
        cr.registerComponent((Object)matcher, ProtobufMatcher.class);
        boolean isIndexed = configuration.indexing().index().isEnabled();
        boolean customStorage = cache.getCacheConfiguration().encoding().valueDataType().isMediaTypeChanged();
        MediaType valueMediaType = this.valueDataConversion.getStorageMediaType();
        boolean isProtoBuf = valueMediaType.match(MediaType.APPLICATION_PROTOSTREAM);
        if (isProtoBuf || !customStorage && isIndexed) {
            this.valueDataConversion.overrideWrapper(ProtobufWrapper.class, cr);
        }
        this.queryEngine = new RemoteQueryEngine(cache, isIndexed);
        EncoderRegistry encoderRegistry = (EncoderRegistry)cr.getGlobalComponentRegistry().getComponent(EncoderRegistry.class);
        this.protobufTranscoder = encoderRegistry.getTranscoder(MediaType.APPLICATION_PROTOSTREAM, MediaType.APPLICATION_OBJECT);
    }

    @Override
    public Class<? extends Matcher> getMatcherClass(MediaType mediaType) {
        return ProtobufMatcher.class;
    }

    @Override
    public BaseRemoteQueryEngine getQueryEngine(AdvancedCache<?, ?> cache) {
        return this.queryEngine;
    }

    @Override
    public QueryRequest decodeQueryRequest(byte[] queryRequest, MediaType mediaType) {
        return (QueryRequest)this.protobufTranscoder.transcode((Object)queryRequest, MediaType.APPLICATION_PROTOSTREAM, QUERY_REQUEST_TYPE);
    }

    @Override
    public byte[] encodeQueryResponse(QueryResponse queryResponse, MediaType mediaType) {
        return (byte[])this.protobufTranscoder.transcode((Object)queryResponse, MediaType.APPLICATION_OBJECT, PROTOSTREAM_UNWRAPPED);
    }

    @Override
    public Object encodeFilterResult(Object filterResult) {
        return this.protobufTranscoder.transcode(filterResult, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_PROTOSTREAM);
    }

    @Override
    public DataConversion getKeyDataConversion() {
        return this.keyDataConversion;
    }

    @Override
    public DataConversion getValueDataConversion() {
        return this.valueDataConversion;
    }
}

