/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.encoding.DataConversion;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;
import org.infinispan.query.remote.impl.BaseRemoteQueryEngine;
import org.infinispan.query.remote.impl.RemoteQueryResult;

public interface RemoteQueryManager {
    public static final MediaType PROTOSTREAM_UNWRAPPED = MediaType.APPLICATION_PROTOSTREAM.withParameter("wrapped", "false");
    public static final MediaType QUERY_REQUEST_TYPE = MediaType.APPLICATION_OBJECT.withParameter("type", QueryRequest.class.getName());

    public Class<? extends Matcher> getMatcherClass(MediaType var1);

    public BaseRemoteQueryEngine getQueryEngine(AdvancedCache<?, ?> var1);

    public QueryRequest decodeQueryRequest(byte[] var1, MediaType var2);

    public byte[] encodeQueryResponse(QueryResponse var1, MediaType var2);

    public Object encodeFilterResult(Object var1);

    default public Object convertKey(Object key, MediaType destinationFormat) {
        DataConversion keyDataConversion = this.getKeyDataConversion();
        MediaType storageMediaType = keyDataConversion.getStorageMediaType();
        return keyDataConversion.convert(key, storageMediaType, destinationFormat);
    }

    default public Object convertValue(Object value, MediaType destinationFormat) {
        DataConversion valueDataConversion = this.getValueDataConversion();
        MediaType storageMediaType = valueDataConversion.getStorageMediaType();
        return valueDataConversion.convert(value, storageMediaType, destinationFormat);
    }

    public DataConversion getKeyDataConversion();

    public DataConversion getValueDataConversion();

    default public List<Object> encodeQueryResults(List<Object> results) {
        DataConversion valueDataConversion = this.getValueDataConversion();
        return results.stream().map(o -> valueDataConversion.convert(o, valueDataConversion.getStorageMediaType(), MediaType.APPLICATION_JSON)).collect(Collectors.toList());
    }

    default public RemoteQueryResult executeQuery(String q, Integer offset, Integer maxResults, IndexedQueryMode queryMode, AdvancedCache cache) {
        Query query = this.getQueryEngine(cache).makeQuery(q, null, offset.intValue(), maxResults, queryMode);
        List results = query.list();
        String[] projection = query.getProjection();
        int totalResults = query.getResultSize();
        if (projection == null) {
            return new RemoteQueryResult(null, totalResults, this.encodeQueryResults(results));
        }
        return new RemoteQueryResult(projection, totalResults, results);
    }
}

