/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.objectfilter.impl.syntax.parser.ReflectionEntityNamesResolver;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.impl.BaseRemoteQueryEngine;
import org.infinispan.query.remote.impl.BaseRemoteQueryManager;
import org.infinispan.query.remote.impl.ObjectReflectionMatcher;
import org.infinispan.query.remote.impl.ObjectRemoteQueryEngine;
import org.infinispan.query.remote.impl.ProtobufEntityNameResolver;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.ProtobufObjectReflectionMatcher;
import org.infinispan.query.remote.impl.QuerySerializers;

class ObjectRemoteQueryManager
extends BaseRemoteQueryManager {
    private Map<String, BaseRemoteQueryEngine> enginePerMediaType = new ConcurrentHashMap<String, BaseRemoteQueryEngine>();
    protected final SerializationContext ctx;
    protected final boolean isIndexed;
    private final ComponentRegistry cr;

    ObjectRemoteQueryManager(ComponentRegistry cr, QuerySerializers querySerializers) {
        super(cr, querySerializers);
        this.cr = cr;
        Configuration cfg = this.cache.getCacheConfiguration();
        this.isIndexed = cfg.indexing().index().isEnabled();
        ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)cr.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        this.ctx = protobufMetadataManager.getSerializationContext();
    }

    @Override
    public Class<? extends Matcher> getMatcherClass(MediaType mediaType) {
        return this.getQueryEngineForMediaType(mediaType).getMatcherClass();
    }

    @Override
    public BaseRemoteQueryEngine getQueryEngine(AdvancedCache<?, ?> cache) {
        return this.getQueryEngineForMediaType(cache.getValueDataConversion().getRequestMediaType());
    }

    @Override
    public Object encodeFilterResult(Object filterResult) {
        return filterResult;
    }

    private BaseRemoteQueryEngine getQueryEngineForMediaType(MediaType mediaType) {
        BaseRemoteQueryEngine queryEngine = this.enginePerMediaType.get(mediaType.getTypeSubtype());
        if (queryEngine != null) {
            return queryEngine;
        }
        SearchIntegrator searchIntegrator = (SearchIntegrator)this.cr.getComponent(SearchIntegrator.class);
        EntityNameResolver entityNameResolver = this.createEntityNamesResolver(mediaType);
        ObjectReflectionMatcher matcher = mediaType.match(MediaType.APPLICATION_PROTOSTREAM) ? ProtobufObjectReflectionMatcher.create(entityNameResolver, this.ctx, searchIntegrator) : ObjectReflectionMatcher.create(entityNameResolver, searchIntegrator);
        this.cr.registerComponent((Object)matcher, ((Object)((Object)matcher)).getClass());
        ObjectRemoteQueryEngine engine = new ObjectRemoteQueryEngine(this.cache, ((Object)((Object)matcher)).getClass(), this.isIndexed);
        this.enginePerMediaType.put(mediaType.getTypeSubtype(), engine);
        return engine;
    }

    private EntityNameResolver createEntityNamesResolver(MediaType mediaType) {
        ReflectionEntityNamesResolver entityNameResolver;
        if (mediaType.match(MediaType.APPLICATION_PROTOSTREAM)) {
            return new ProtobufEntityNameResolver(this.ctx);
        }
        ClassLoader classLoader = (ClassLoader)this.cr.getGlobalComponentRegistry().getComponent(ClassLoader.class);
        ReflectionEntityNamesResolver reflectionEntityNamesResolver = new ReflectionEntityNamesResolver(classLoader);
        if (this.isIndexed) {
            Set knownClasses = ((QueryInterceptor)this.cr.getComponent(QueryInterceptor.class)).getKnownClasses();
            entityNameResolver = name -> knownClasses.stream().filter(c -> c.getName().equals(name)).findFirst().orElse(reflectionEntityNamesResolver.resolve(name));
        } else {
            entityNameResolver = reflectionEntityNamesResolver;
        }
        return entityNameResolver;
    }
}

