/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.impl.IndexedTypeMaps;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.QueryDefinition;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.embedded.impl.IckleFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.RowProcessor;
import org.infinispan.query.remote.impl.BaseRemoteQueryEngine;
import org.infinispan.query.remote.impl.ProtobufFieldBridgeAndAnalyzerProvider;
import org.infinispan.query.remote.impl.ProtobufWrapper;
import org.infinispan.query.remote.impl.RemoteQueryDefinition;
import org.infinispan.query.remote.impl.filter.IckleProtobufFilterAndConverter;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;

final class RemoteQueryEngine
extends BaseRemoteQueryEngine {
    RemoteQueryEngine(AdvancedCache<?, ?> cache, boolean isIndexed) {
        super(isIndexed ? cache.withWrapping(ByteArrayWrapper.class, ProtobufWrapper.class) : cache, isIndexed, ProtobufMatcher.class, new ProtobufFieldBridgeAndAnalyzerProvider());
    }

    protected RowProcessor makeProjectionProcessor(Class<?>[] projectedTypes, Object[] projectedNullMarkers) {
        int[] booleanPositions = new int[projectedTypes.length];
        int booleanColumnsNumber = 0;
        for (int i = 0; i < projectedTypes.length; ++i) {
            if (projectedTypes[i] != Boolean.class) continue;
            booleanPositions[booleanColumnsNumber++] = i;
        }
        boolean hasNullMarkers = false;
        if (projectedNullMarkers != null) {
            for (Object projectedNullMarker : projectedNullMarkers) {
                if (projectedNullMarker == null) continue;
                hasNullMarkers = true;
                break;
            }
        }
        if (booleanColumnsNumber == 0 && !hasNullMarkers) {
            return null;
        }
        boolean hasNullMarkers_ = hasNullMarkers;
        int[] booleanColumns = booleanColumnsNumber < booleanPositions.length ? Arrays.copyOf(booleanPositions, booleanColumnsNumber) : booleanPositions;
        return row -> {
            if (hasNullMarkers_) {
                for (int i = 0; i < projectedNullMarkers.length; ++i) {
                    if (row[i] == null || !row[i].equals(projectedNullMarkers[i])) continue;
                    row[i] = null;
                }
            }
            for (int i : booleanColumns) {
                if (row[i] == null) continue;
                row[i] = "true".equals(row[i]);
            }
            return row;
        };
    }

    protected Query makeTypeQuery(Query query, String targetEntityName) {
        return new BooleanQuery.Builder().add((Query)new TermQuery(new Term("$type$", targetEntityName)), BooleanClause.Occur.FILTER).add(query, BooleanClause.Occur.MUST).build();
    }

    protected CacheQuery<?> makeCacheQuery(IckleParsingResult<Descriptor> ickleParsingResult, Query luceneQuery, IndexedQueryMode queryMode, Map<String, Object> namedParameters) {
        IndexingMetadata indexingMetadata = (IndexingMetadata)((Descriptor)ickleParsingResult.getTargetEntityMetadata()).getProcessedAnnotation("Indexed");
        Set<Object> sortableFields = indexingMetadata != null ? indexingMetadata.getSortableFields() : Collections.emptySet();
        IndexedTypeMap queryMetadata = IndexedTypeMaps.singletonMapping((IndexedTypeIdentifier)ProtobufValueWrapper.INDEXING_TYPE, () -> sortableFields);
        RemoteQueryDefinition queryDefinition = queryMode == IndexedQueryMode.BROADCAST ? new RemoteQueryDefinition(ickleParsingResult.getQueryString()) : new RemoteQueryDefinition(this.getSearchFactory().createHSQuery(luceneQuery, queryMetadata));
        queryDefinition.setNamedParameters(namedParameters);
        return this.getSearchManager().getQuery((QueryDefinition)queryDefinition, queryMode, queryMetadata);
    }

    protected IckleFilterAndConverter createFilter(String queryString, Map<String, Object> namedParameters) {
        return this.isIndexed ? new IckleProtobufFilterAndConverter(queryString, namedParameters) : super.createFilter(queryString, namedParameters);
    }

    protected Class<?> getTargetedClass(IckleParsingResult<?> parsingResult) {
        return ProtobufValueWrapper.class;
    }
}

