/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.dataconversion;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.util.logging.Log;

public class ProtostreamTextTranscoder
implements Transcoder {
    private static final Log log = (Log)LogFactory.getLog(ProtostreamTextTranscoder.class, Log.class);
    private final Set<MediaType> supported = new HashSet<MediaType>();
    private final SerializationContext ctx;

    public ProtostreamTextTranscoder(SerializationContext ctx) {
        this.supported.add(MediaType.APPLICATION_PROTOSTREAM);
        this.supported.add(MediaType.TEXT_PLAIN);
        this.ctx = ctx;
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        try {
            if (destinationType.match(MediaType.APPLICATION_PROTOSTREAM)) {
                return ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)this.ctx, (Object)content);
            }
            if (destinationType.match(MediaType.TEXT_PLAIN)) {
                return ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.ctx, (byte[])((byte[])content));
            }
        }
        catch (IOException e) {
            throw log.errorTranscoding((Throwable)e);
        }
        throw log.unsupportedContent(content);
    }

    public Set<MediaType> getSupportedMediaTypes() {
        return this.supported;
    }
}

