/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.infinispan.commons.CacheException;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.indexing.IndexingTagHandler;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.indexing.WrappedMessageTagHandler;

final class IndexingWrappedMessageTagHandler
extends WrappedMessageTagHandler {
    private final Document document;
    private final LuceneOptions luceneOptions;

    IndexingWrappedMessageTagHandler(ProtobufValueWrapper valueWrapper, SerializationContext serCtx, Document document, LuceneOptions luceneOptions) {
        super(valueWrapper, serCtx);
        this.document = document;
        this.luceneOptions = luceneOptions;
    }

    @Override
    public void onEnd() {
        super.onEnd();
        if (this.bytes != null) {
            IndexingMetadata indexingMetadata = (IndexingMetadata)this.messageDescriptor.getProcessedAnnotation("Indexed");
            if (indexingMetadata == null && IndexingMetadata.isLegacyIndexingEnabled(this.messageDescriptor) || indexingMetadata != null && indexingMetadata.isIndexed()) {
                if (indexingMetadata == null) {
                    log.legacyIndexingIsDeprecated(this.messageDescriptor.getFullName(), this.messageDescriptor.getFileDescriptor().getName());
                }
                this.valueWrapper.setMessageDescriptor(this.messageDescriptor);
                try {
                    ProtobufParser.INSTANCE.parse((TagHandler)new IndexingTagHandler(this.messageDescriptor, this.document), this.messageDescriptor, this.bytes);
                }
                catch (IOException e) {
                    throw new CacheException((Throwable)e);
                }
            }
        } else if (this.numericValue != null) {
            this.luceneOptions.addNumericFieldToDocument("theValue", (Object)this.numericValue, this.document);
        } else if (this.stringValue != null) {
            this.luceneOptions.addFieldToDocument("theValue", this.stringValue, this.document);
        }
    }
}

