/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.infinispan.commons.CacheException;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.backend.ExtendedSearchWorkCreator;
import org.infinispan.query.backend.SearchWorkCreator;
import org.infinispan.query.backend.SearchWorkCreatorContext;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.indexing.WrappedMessageTagHandler;

public final class ProtobufValueWrapperSearchWorkCreator {
    private final SearchWorkCreator delegate;
    private final SerializationContext serializationContext;
    private final Descriptor wrapperDescriptor;

    public ProtobufValueWrapperSearchWorkCreator(SearchWorkCreator searchWorkCreator, SerializationContext serializationContext) {
        if (searchWorkCreator == null) {
            throw new IllegalArgumentException("searchWorkCreator argument cannot be null");
        }
        this.delegate = searchWorkCreator;
        this.serializationContext = serializationContext;
        this.wrapperDescriptor = serializationContext.getMessageDescriptor("org.infinispan.protostream.WrappedMessage");
    }

    public SearchWorkCreator get() {
        return this.delegate instanceof ExtendedSearchWorkCreator ? new ExtendedDelegate() : new Delegate();
    }

    private Object interceptValue(Object value) {
        if (value instanceof ProtobufValueWrapper) {
            this.discoverMessageType((ProtobufValueWrapper)value);
        }
        return value;
    }

    private void discoverMessageType(ProtobufValueWrapper valueWrapper) {
        try {
            ProtobufParser.INSTANCE.parse((TagHandler)new WrappedMessageTagHandler(valueWrapper, this.serializationContext), this.wrapperDescriptor, valueWrapper.getBinary());
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private final class ExtendedDelegate
    extends Delegate
    implements ExtendedSearchWorkCreator {
        private ExtendedDelegate() {
        }

        public boolean shouldRemove(SearchWorkCreatorContext context) {
            return ((ExtendedSearchWorkCreator)ProtobufValueWrapperSearchWorkCreator.this.delegate).shouldRemove(new SearchWorkCreatorContext(ProtobufValueWrapperSearchWorkCreator.this.interceptValue(context.getPreviousValue()), ProtobufValueWrapperSearchWorkCreator.this.interceptValue(context.getCurrentValue())));
        }
    }

    private class Delegate
    implements SearchWorkCreator {
        private Delegate() {
        }

        public Collection<Work> createPerEntityTypeWorks(IndexedTypeIdentifier entityType, WorkType workType) {
            return ProtobufValueWrapperSearchWorkCreator.this.delegate.createPerEntityTypeWorks(entityType, workType);
        }

        public Collection<Work> createPerEntityWorks(Object entity, Serializable id, WorkType workType) {
            return ProtobufValueWrapperSearchWorkCreator.this.delegate.createPerEntityWorks(ProtobufValueWrapperSearchWorkCreator.this.interceptValue(entity), id, workType);
        }

        public Work createEntityWork(Serializable id, IndexedTypeIdentifier entityType, WorkType workType) {
            return ProtobufValueWrapperSearchWorkCreator.this.delegate.createEntityWork(id, entityType, workType);
        }
    }
}

