/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.IOException;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.event.ClientCacheFailoverEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.ContinuousQueryListener;
import org.infinispan.client.hotrod.filter.Filters;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.remote.client.ContinuousQueryResult;

public class ClientEvents {
    @Deprecated
    public static final String QUERY_DSL_FILTER_FACTORY_NAME = "query-dsl-filter-converter-factory";
    @Deprecated
    public static final String CONTINUOUS_QUERY_FILTER_FACTORY_NAME = "continuous-query-filter-converter-factory";
    private static final ClientCacheFailoverEvent FAILOVER_EVENT_SINGLETON = new ClientCacheFailoverEvent(){

        @Override
        public ClientEvent.Type getType() {
            return ClientEvent.Type.CLIENT_CACHE_FAILOVER;
        }
    };

    private ClientEvents() {
    }

    public static ClientCacheFailoverEvent mkCachefailoverEvent() {
        return FAILOVER_EVENT_SINGLETON;
    }

    public static void addClientQueryListener(RemoteCache<?, ?> remoteCache, Object listener, Query query) {
        ClientListener l = listener.getClass().getAnnotation(ClientListener.class);
        if (!l.useRawData()) {
            throw new IllegalArgumentException("The client listener must use raw data");
        }
        if (!l.filterFactoryName().equals(QUERY_DSL_FILTER_FACTORY_NAME)) {
            throw new IllegalArgumentException("The client listener must use the 'query-dsl-filter-converter-factory' filter factory");
        }
        if (!l.converterFactoryName().equals(QUERY_DSL_FILTER_FACTORY_NAME)) {
            throw new IllegalArgumentException("The client listener must use the 'query-dsl-filter-converter-factory' converter factory");
        }
        Object[] factoryParams = Filters.makeFactoryParams(query);
        remoteCache.addClientListener(listener, factoryParams, null);
    }

    public static Object addContinuousQueryListener(RemoteCache<?, ?> remoteCache, ContinuousQueryListener queryListener, Query query) {
        SerializationContext serCtx = ProtoStreamMarshaller.getSerializationContext(remoteCache.getRemoteCacheManager());
        ClientEntryListener eventListener = new ClientEntryListener(serCtx, queryListener);
        Object[] factoryParams = Filters.makeFactoryParams(query);
        remoteCache.addClientListener(eventListener, factoryParams, null);
        return eventListener;
    }

    @ClientListener(filterFactoryName="continuous-query-filter-converter-factory", converterFactoryName="continuous-query-filter-converter-factory", useRawData=true, includeCurrentState=true)
    private static final class ClientEntryListener {
        private final SerializationContext serializationContext;
        private final ContinuousQueryListener queryListener;

        public ClientEntryListener(SerializationContext serializationContext, ContinuousQueryListener queryListener) {
            this.serializationContext = serializationContext;
            this.queryListener = queryListener;
        }

        @ClientCacheEntryCreated
        @ClientCacheEntryModified
        @ClientCacheEntryRemoved
        @ClientCacheEntryExpired
        public void handleClientCacheEntryCreatedEvent(ClientCacheEntryCustomEvent event) throws IOException {
            Object value;
            ContinuousQueryResult cqresult = ProtobufUtil.fromByteArray(this.serializationContext, (byte[])event.getEventData(), ContinuousQueryResult.class);
            Object key = ProtobufUtil.fromWrappedByteArray(this.serializationContext, cqresult.getKey());
            Object object = value = cqresult.getValue() != null ? ProtobufUtil.fromWrappedByteArray(this.serializationContext, cqresult.getValue()) : null;
            if (cqresult.isJoining()) {
                this.queryListener.resultJoining(key, value);
            } else {
                this.queryListener.resultLeaving(key);
            }
        }
    }
}

