/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller;

import infinispan.org.jboss.as.controller.AttributeDefinition;
import infinispan.org.jboss.as.controller.ObjectTypeAttributeDefinition;
import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.ServiceVerificationHelper;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import infinispan.org.jboss.as.controller.SimpleListAttributeDefinition;
import infinispan.org.jboss.as.controller.SimpleOperationDefinition;
import infinispan.org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import infinispan.org.jboss.as.controller.access.Action;
import infinispan.org.jboss.as.controller.access.AuthorizationResult;
import infinispan.org.jboss.as.controller.access.management.AuthorizedAddress;
import infinispan.org.jboss.as.controller.descriptions.common.ControllerResolver;
import infinispan.org.jboss.as.controller.registry.OperationEntry;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import java.util.HashSet;
import java.util.Set;

public class BootErrorCollector {
    private static final String COMPLETE_OP = "real-operation";
    private final ModelNode errors = new ModelNode();
    private final OperationStepHandler listBootErrorsHandler;

    public BootErrorCollector() {
        this.errors.setEmptyList();
        this.listBootErrorsHandler = new ListBootErrorsHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFailureDescription(ModelNode operation, ModelNode failureDescription) {
        assert (operation != null);
        assert (failureDescription != null);
        ModelNode error = new ModelNode();
        ModelNode failedOperation = error.get("failed-operation");
        failedOperation.get("operation").set(operation.get("operation"));
        ModelNode opAddr = operation.get("address");
        if (!opAddr.isDefined()) {
            opAddr.setEmptyList();
        }
        failedOperation.get("address").set(opAddr);
        error.get("failure-description").set(failureDescription.asString());
        ModelNode report = ServiceVerificationHelper.extractFailedServicesDescription(failureDescription);
        if (report != null) {
            error.get("failed-services").set(report);
        }
        if ((report = ServiceVerificationHelper.extractMissingServicesDescription(failureDescription)) != null) {
            error.get("services-missing-dependencies").set(report);
        }
        if ((report = ServiceVerificationHelper.extractTransitiveDependencyProblemDescription(failureDescription)) != null) {
            error.get("missing-transitive-dependency-problems").set(report);
        }
        error.get(COMPLETE_OP).set(operation);
        ModelNode modelNode = this.errors;
        synchronized (modelNode) {
            this.errors.add(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelNode getErrors() {
        ModelNode modelNode = this.errors;
        synchronized (modelNode) {
            return this.errors.clone();
        }
    }

    public OperationStepHandler getReadBootErrorsHandler() {
        return this.listBootErrorsHandler;
    }

    public static class ListBootErrorsHandler
    implements OperationStepHandler {
        private static final String OPERATION_NAME = "read-boot-errors";
        private final BootErrorCollector errors;
        private static final AttributeDefinition OP_DEFINITION = ObjectTypeAttributeDefinition.Builder.of("failed-operation", SimpleAttributeDefinitionBuilder.create("operation", ModelType.STRING, false).build(), SimpleListAttributeDefinition.Builder.of("address", SimpleAttributeDefinitionBuilder.create("element", ModelType.PROPERTY, false).build()).build()).setAllowNull(false).build();
        private static final AttributeDefinition FAILURE_MESSAGE = SimpleAttributeDefinitionBuilder.create("failure-description", ModelType.STRING, false).build();
        private static final AttributeDefinition FAILED_SVC_AD = SimpleListAttributeDefinition.Builder.of("failed-services", SimpleAttributeDefinitionBuilder.create("element", ModelType.STRING, false).build()).setAllowNull(true).build();
        private static final AttributeDefinition MISSING_DEPS_AD = SimpleListAttributeDefinition.Builder.of("services-missing-dependencies", SimpleAttributeDefinitionBuilder.create("element", ModelType.STRING, false).build()).setAllowNull(true).build();
        private static final AttributeDefinition AFFECTED_AD = SimpleListAttributeDefinition.Builder.of("services-missing-transitive-dependencies", SimpleAttributeDefinitionBuilder.create("element", ModelType.STRING, false).build()).build();
        private static final AttributeDefinition CAUSE_AD = SimpleListAttributeDefinition.Builder.of("possible-causes", SimpleAttributeDefinitionBuilder.create("element", ModelType.STRING, false).build()).build();
        private static final AttributeDefinition TRANSITIVE_AD = ObjectTypeAttributeDefinition.Builder.of("missing-transitive-dependency-problems", AFFECTED_AD, CAUSE_AD).setAllowNull(true).build();
        public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-boot-errors", ControllerResolver.getResolver("errors")).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyParameters(OP_DEFINITION, FAILURE_MESSAGE, FAILED_SVC_AD, MISSING_DEPS_AD, TRANSITIVE_AD).build();

        ListBootErrorsHandler(BootErrorCollector errors) {
            this.errors = errors;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode bootErrors = new ModelNode().setEmptyList();
                    ModelNode errorsNode = errors.getErrors();
                    for (ModelNode bootError : errorsNode.asList()) {
                        this.secureOperationAddress(context, bootError);
                        bootErrors.add(bootError);
                    }
                    context.getResult().set(bootErrors);
                }
            }, OperationContext.Stage.RUNTIME);
        }

        private void secureOperationAddress(OperationContext context, ModelNode bootError) throws OperationFailedException {
            if (bootError.hasDefined("failed-operation")) {
                ModelNode failedOperation = bootError.get("failed-operation");
                ModelNode address = failedOperation.get("address");
                ModelNode fakeOperation = new ModelNode();
                fakeOperation.get("operation").set("read-resource");
                fakeOperation.get("address").set(address);
                AuthorizedAddress authorizedAddress = AuthorizedAddress.authorizeAddress(context, fakeOperation);
                if (authorizedAddress.isElided()) {
                    failedOperation.get("address").set(authorizedAddress.getAddress());
                }
                if (bootError.has("failure-description") && !this.canReadFailureDescription(context, bootError)) {
                    bootError.get("failure-description").set(new ModelNode());
                }
            }
            bootError.remove(BootErrorCollector.COMPLETE_OP);
        }

        private boolean canReadFailureDescription(OperationContext context, ModelNode bootError) {
            ModelNode completeOPeration = bootError.get(BootErrorCollector.COMPLETE_OP);
            OperationEntry operationEntry = context.getRootResourceRegistration().getOperationEntry(PathAddress.pathAddress(completeOPeration.get("address")), completeOPeration.get("operation").asString());
            Set<Action.ActionEffect> effects = this.getEffects(operationEntry);
            return context.authorize(bootError.get(BootErrorCollector.COMPLETE_OP), effects).getDecision() == AuthorizationResult.Decision.PERMIT;
        }

        Set<Action.ActionEffect> getEffects(OperationEntry operationEntry) {
            HashSet<Action.ActionEffect> effects = new HashSet<Action.ActionEffect>(5);
            effects.add(Action.ActionEffect.ADDRESS);
            if (operationEntry != null) {
                effects.add(Action.ActionEffect.READ_RUNTIME);
                if (!operationEntry.getFlags().contains((Object)OperationEntry.Flag.RUNTIME_ONLY)) {
                    effects.add(Action.ActionEffect.READ_CONFIG);
                }
                if (!operationEntry.getFlags().contains((Object)OperationEntry.Flag.READ_ONLY)) {
                    effects.add(Action.ActionEffect.WRITE_RUNTIME);
                    if (!operationEntry.getFlags().contains((Object)OperationEntry.Flag.RUNTIME_ONLY)) {
                        effects.add(Action.ActionEffect.WRITE_CONFIG);
                    }
                }
            }
            return effects;
        }
    }
}

