/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.capability.registry;

import infinispan.org.jboss.as.controller.capability.registry.CapabilityResolutionContext;
import infinispan.org.jboss.as.controller.capability.registry.CapabilityScope;
import infinispan.org.jboss.as.controller.registry.Resource;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

abstract class IncludingResourceCapabilityScope
implements CapabilityScope {
    final CapabilityResolutionContext.AttachmentKey<Map<String, Set<CapabilityScope>>> attachmentKey;
    final String type;
    final String value;

    IncludingResourceCapabilityScope(CapabilityResolutionContext.AttachmentKey<Map<String, Set<CapabilityScope>>> attachmentKey, String type, String value) {
        this.attachmentKey = attachmentKey;
        this.type = type;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.type + "=" + this.value;
    }

    @Override
    public Set<CapabilityScope> getIncludingScopes(CapabilityResolutionContext context) {
        Set<CapabilityScope> result;
        Map<String, Set<CapabilityScope>> attached = context.getAttachment(this.attachmentKey);
        if (attached == null) {
            String name;
            attached = new HashMap<String, Set<CapabilityScope>>();
            HashMap<String, Set<String>> included = new HashMap<String, Set<String>>();
            Set<Resource.ResourceEntry> children = context.getResourceRoot().getChildren(this.type);
            for (Resource.ResourceEntry resource : children) {
                name = resource.getName();
                Set<String> includes = IncludingResourceCapabilityScope.getIncludes(resource);
                included.put(name, includes);
                attached.put(name, new HashSet());
            }
            for (Resource.ResourceEntry resource : children) {
                name = resource.getName();
                IncludingResourceCapabilityScope.storeIncludes(this.createIncludedContext(name), name, attached, included);
            }
            context.attach(this.attachmentKey, attached);
        }
        return (result = attached.get(this.value)) == null ? Collections.emptySet() : result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.getName() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncludingResourceCapabilityScope that = (IncludingResourceCapabilityScope)o;
        return this.type.equals(that.type) && this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    protected abstract CapabilityScope createIncludedContext(String var1);

    private static Set<String> getIncludes(Resource.ResourceEntry resource) {
        Set<String> result;
        ModelNode model = resource.getModel();
        if (model.hasDefined("includes")) {
            result = new HashSet();
            for (ModelNode node : model.get("includes").asList()) {
                result.add(node.asString());
            }
        } else {
            result = Collections.emptySet();
        }
        return result;
    }

    private static void storeIncludes(CapabilityScope includedContext, String key, Map<String, Set<CapabilityScope>> attached, Map<String, Set<String>> included) {
        for (String includer : included.get(key)) {
            Set<CapabilityScope> includees;
            if (includedContext.getName().equals(includer) || (includees = attached.get(includer)) == null) continue;
            includees.add(includedContext);
            IncludingResourceCapabilityScope.storeIncludes(includedContext, includer, attached, included);
        }
    }
}

