/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.client;

import infinispan.org.jboss.as.controller.client.ModelControllerClientConfiguration;
import infinispan.org.jboss.as.controller.client.Operation;
import infinispan.org.jboss.as.controller.client.OperationMessageHandler;
import infinispan.org.jboss.as.controller.client.OperationResponse;
import infinispan.org.jboss.as.controller.client.impl.RemotingModelControllerClient;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.threads.AsyncFuture;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;

public interface ModelControllerClient
extends Closeable {
    public ModelNode execute(ModelNode var1) throws IOException;

    public ModelNode execute(Operation var1) throws IOException;

    public ModelNode execute(ModelNode var1, OperationMessageHandler var2) throws IOException;

    public ModelNode execute(Operation var1, OperationMessageHandler var2) throws IOException;

    public OperationResponse executeOperation(Operation var1, OperationMessageHandler var2) throws IOException;

    public AsyncFuture<ModelNode> executeAsync(ModelNode var1, OperationMessageHandler var2);

    public AsyncFuture<ModelNode> executeAsync(Operation var1, OperationMessageHandler var2);

    public AsyncFuture<OperationResponse> executeOperationAsync(Operation var1, OperationMessageHandler var2);

    public static class Factory {
        public static ModelControllerClient create(InetAddress address, int port) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHostName(address.getHostAddress()).setPort(port).build());
        }

        public static ModelControllerClient create(String protocol, InetAddress address, int port) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHostName(address.getHostAddress()).setPort(port).setProtocol(protocol).build());
        }

        public static ModelControllerClient create(InetAddress address, int port, CallbackHandler handler) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(address.getHostAddress()).setPort(port).build());
        }

        public static ModelControllerClient create(String protocol, InetAddress address, int port, CallbackHandler handler) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(address.getHostAddress()).setPort(port).setProtocol(protocol).build());
        }

        @Deprecated
        public static ModelControllerClient create(InetAddress address, int port, CallbackHandler handler, Map<String, String> saslOptions) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(address.getHostAddress()).setPort(port).setSaslOptions(saslOptions).build());
        }

        @Deprecated
        public static ModelControllerClient create(String protocol, InetAddress address, int port, CallbackHandler handler, Map<String, String> saslOptions) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(address.getHostAddress()).setPort(port).setProtocol(protocol).setSaslOptions(saslOptions).build());
        }

        public static ModelControllerClient create(String hostName, int port) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHostName(hostName).setPort(port).build());
        }

        public static ModelControllerClient create(String protocol, String hostName, int port) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHostName(hostName).setPort(port).setProtocol(protocol).build());
        }

        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(hostName).setPort(port).build());
        }

        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).build());
        }

        @Deprecated
        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler, SSLContext sslContext) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(hostName).setPort(port).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setConnectionTimeout(connectionTimeout).setHandler(handler).setHostName(hostName).setPort(port).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setConnectionTimeout(connectionTimeout).setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout, Map<String, String> saslOptions) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setConnectionTimeout(connectionTimeout).setHandler(handler).setHostName(hostName).setPort(port).setSaslOptions(saslOptions).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout, Map<String, String> saslOptions) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setConnectionTimeout(connectionTimeout).setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).setSaslOptions(saslOptions).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout, Map<String, String> saslOptions, String clientBindAddress) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setClientBindAddress(clientBindAddress).setConnectionTimeout(connectionTimeout).setHandler(handler).setHostName(hostName).setPort(port).setSaslOptions(saslOptions).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout, Map<String, String> saslOptions, String clientBindAddress) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setClientBindAddress(clientBindAddress).setConnectionTimeout(connectionTimeout).setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).setSaslOptions(saslOptions).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler, Map<String, String> saslOptions) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(hostName).setPort(port).setSaslOptions(saslOptions).build());
        }

        @Deprecated
        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler, Map<String, String> saslOptions) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).setSaslOptions(saslOptions).build());
        }

        public static ModelControllerClient create(ModelControllerClientConfiguration configuration) {
            return new RemotingModelControllerClient(configuration);
        }
    }
}

