/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.descriptions;

import infinispan.org.jboss.as.controller.NotificationDefinition;
import infinispan.org.jboss.as.controller.descriptions.DescriptionProvider;
import infinispan.org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.Locale;
import java.util.ResourceBundle;

public class DefaultNotificationDescriptionProvider
implements DescriptionProvider {
    private final String notificationType;
    private final ResourceDescriptionResolver descriptionResolver;
    private final NotificationDefinition.DataValueDescriptor dataValueDescriptor;

    public DefaultNotificationDescriptionProvider(String notificationType, ResourceDescriptionResolver descriptionResolver, NotificationDefinition.DataValueDescriptor dataValueDescriptor) {
        this.notificationType = notificationType;
        this.descriptionResolver = descriptionResolver;
        this.dataValueDescriptor = dataValueDescriptor;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        ModelNode dataDescription;
        ModelNode result = new ModelNode();
        ResourceBundle bundle2 = this.descriptionResolver.getResourceBundle(locale);
        result.get("notification-type").set(this.notificationType);
        result.get("description").set(this.descriptionResolver.getNotificationDescription(this.notificationType, locale, bundle2));
        if (this.dataValueDescriptor != null && (dataDescription = this.dataValueDescriptor.describe(bundle2)) != null && dataDescription.isDefined()) {
            result.get("data-type").set(dataDescription);
        }
        return result;
    }
}

