/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.extension;

import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.extension.ExtensionAddHandler;
import infinispan.org.jboss.as.controller.extension.ExtensionRegistry;
import infinispan.org.jboss.as.controller.extension.ExtensionRegistryType;
import infinispan.org.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import infinispan.org.jboss.as.controller.registry.ManagementResourceRegistration;
import infinispan.org.jboss.dmr.ModelNode;

public class ExtensionRemoveHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "remove";
    private final ExtensionRegistry extensionRegistry;
    private final ExtensionRegistryType extensionRegistryType;
    private final MutableRootResourceRegistrationProvider rootResourceRegistrationProvider;

    public ExtensionRemoveHandler(ExtensionRegistry extensionRegistry, ExtensionRegistryType extensionRegistryType, MutableRootResourceRegistrationProvider rootResourceRegistrationProvider) {
        this.extensionRegistry = extensionRegistry;
        this.extensionRegistryType = extensionRegistryType;
        this.rootResourceRegistrationProvider = rootResourceRegistrationProvider;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String module = context.getCurrentAddressValue();
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        final ManagementResourceRegistration rootRegistration = this.rootResourceRegistrationProvider.getRootResourceRegistrationForUpdate(context);
        this.extensionRegistry.removeExtension(context.readResourceFromRoot(rootRegistration.getPathAddress()), module, rootRegistration);
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                ExtensionAddHandler.initializeExtension(ExtensionRemoveHandler.this.extensionRegistry, module, rootRegistration, ExtensionRemoveHandler.this.extensionRegistryType);
            }
        });
    }
}

