/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.transform;

import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationDefinition;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.PathElement;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinition;
import infinispan.org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import infinispan.org.jboss.as.controller.descriptions.NonResolvingResourceDescriptionResolver;
import infinispan.org.jboss.as.controller.extension.ExtensionRegistry;
import infinispan.org.jboss.as.controller.extension.SubsystemInformation;
import infinispan.org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;

public class SubsystemDescriptionDump
implements OperationStepHandler {
    private final ExtensionRegistry extensionRegistry;
    protected static final SimpleAttributeDefinition PATH = new SimpleAttributeDefinition("path", ModelType.STRING, false);
    public static final String OPERATION_NAME = "subsystem-description-dump";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("subsystem-description-dump", new NonResolvingResourceDescriptionResolver()).setPrivateEntry().setReadOnly().setParameters(PATH).build();

    public SubsystemDescriptionDump(ExtensionRegistry extensionRegistry) {
        this.extensionRegistry = extensionRegistry;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String path = PATH.resolveModelAttribute(context, operation).asString();
        PathAddress profileAddress = PathAddress.pathAddress(PathElement.pathElement("profile"));
        ImmutableManagementResourceRegistration profileRegistration = context.getResourceRegistration().getSubModel(profileAddress);
        SubsystemDescriptionDump.dumpManagementResourceRegistration(profileRegistration, this.extensionRegistry, path);
    }

    public static void dumpManagementResourceRegistration(ImmutableManagementResourceRegistration profileRegistration, ExtensionRegistry registry, String path) throws OperationFailedException {
        try {
            for (PathElement pe : profileRegistration.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
                ImmutableManagementResourceRegistration registration = profileRegistration.getSubModel(PathAddress.pathAddress(pe));
                String subsystem = pe.getValue();
                SubsystemInformation info = registry.getSubsystemInfo(subsystem);
                ModelNode desc = SubsystemDescriptionDump.readFullModelDescription(PathAddress.pathAddress(pe), registration);
                String name = subsystem + "-" + info.getManagementInterfaceMajorVersion() + "." + info.getManagementInterfaceMinorVersion() + "." + info.getManagementInterfaceMicroVersion() + ".dmr";
                PrintWriter pw = new PrintWriter(new File(path, name));
                desc.writeString(pw, false);
                pw.close();
            }
        }
        catch (IOException e) {
            throw new OperationFailedException("could not save,", e);
        }
    }

    public static ModelNode readFullModelDescription(PathAddress address, ImmutableManagementResourceRegistration reg) {
        ModelNode node = new ModelNode();
        node.get("model-description").set(reg.getModelDescription(PathAddress.EMPTY_ADDRESS).getModelDescription(Locale.getDefault()));
        node.get("address").set(address.toModelNode());
        for (PathElement pe : reg.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
            ModelNode children = node.get("children");
            ImmutableManagementResourceRegistration sub = reg.getSubModel(PathAddress.pathAddress(pe));
            children.add(SubsystemDescriptionDump.readFullModelDescription(address.append(pe), sub));
        }
        return node;
    }
}

