/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.transform.description;

import infinispan.org.jboss.as.controller.AttributeDefinition;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.PathElement;
import infinispan.org.jboss.as.controller.transform.TransformationContext;
import infinispan.org.jboss.dmr.ModelNode;

public interface AttributeConverter {
    public static final AttributeConverter NAME_FROM_ADDRESS = new DefaultAttributeConverter(){

        @Override
        public void convertAttribute(PathAddress address, String name, ModelNode attributeValue, TransformationContext context) {
            PathElement element = address.getLastElement();
            attributeValue.set(element.getValue());
        }
    };

    public void convertOperationParameter(PathAddress var1, String var2, ModelNode var3, ModelNode var4, TransformationContext var5);

    public void convertResourceAttribute(PathAddress var1, String var2, ModelNode var3, TransformationContext var4);

    public static class Factory {
        public static AttributeConverter createHardCoded(ModelNode hardCodedValue) {
            return Factory.createHardCoded(hardCodedValue, false);
        }

        public static AttributeConverter createHardCoded(final ModelNode hardCodedValue, final boolean undefinedOnly) {
            return new DefaultAttributeConverter(){

                @Override
                public void convertAttribute(PathAddress address, String name, ModelNode attributeValue, TransformationContext context) {
                    if (!undefinedOnly || !attributeValue.isDefined()) {
                        attributeValue.set(hardCodedValue);
                    }
                }
            };
        }
    }

    public static class DefaultValueAttributeConverter
    extends DefaultAttributeConverter {
        private final AttributeDefinition attribute;

        public DefaultValueAttributeConverter(AttributeDefinition attribute) {
            this.attribute = attribute;
        }

        @Override
        protected void convertAttribute(PathAddress address, String name, ModelNode value, TransformationContext context) {
            if (!value.isDefined()) {
                value.set(this.attribute.getDefaultValue());
            }
        }
    }

    public static abstract class DefaultAttributeConverter
    implements AttributeConverter {
        @Override
        public void convertOperationParameter(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
            this.convertAttribute(address, attributeName, attributeValue, context);
        }

        @Override
        public void convertResourceAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            this.convertAttribute(address, attributeName, attributeValue, context);
        }

        protected abstract void convertAttribute(PathAddress var1, String var2, ModelNode var3, TransformationContext var4);
    }
}

