/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.modules;

import infinispan.org.jboss.modules.LocalLoader;
import infinispan.org.jboss.modules.Resource;
import infinispan.org.jboss.modules.filter.ClassFilter;
import infinispan.org.jboss.modules.filter.PathFilter;
import java.util.Collections;
import java.util.List;

class FilteredLocalLoader
implements LocalLoader {
    private final ClassFilter classFilter;
    private final LocalLoader originalLoader;
    private final PathFilter resourcePathFilter;

    FilteredLocalLoader(ClassFilter classFilter, PathFilter resourcePathFilter, LocalLoader originalLoader) {
        this.classFilter = classFilter;
        this.originalLoader = originalLoader;
        this.resourcePathFilter = resourcePathFilter;
    }

    @Override
    public Class<?> loadClassLocal(String name, boolean resolve) {
        return this.classFilter.accept(name) ? this.originalLoader.loadClassLocal(name, resolve) : null;
    }

    @Override
    public Package loadPackageLocal(String name) {
        return this.originalLoader.loadPackageLocal(name);
    }

    @Override
    public List<Resource> loadResourceLocal(String name) {
        return this.resourcePathFilter.accept(name) ? this.originalLoader.loadResourceLocal(name) : Collections.emptyList();
    }
}

